/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CompliantSummary;

@SdkInternalApi
public class CompliantSummaryMarshaller {
    private static final MarshallingInfo<Integer> COMPLIANTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompliantCount").build();
    private static final MarshallingInfo<StructuredPojo> SEVERITYSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SeveritySummary").build();
    private static final CompliantSummaryMarshaller INSTANCE = new CompliantSummaryMarshaller();

    public static CompliantSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompliantSummary compliantSummary, ProtocolMarshaller protocolMarshaller) {
        if (compliantSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compliantSummary.compliantCount(), COMPLIANTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)compliantSummary.severitySummary(), SEVERITYSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

