/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryAggregator;

@SdkInternalApi
public class InventoryAggregatorMarshaller {
    private static final MarshallingInfo<String> EXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expression").build();
    private static final MarshallingInfo<List> AGGREGATORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Aggregators").build();
    private static final InventoryAggregatorMarshaller INSTANCE = new InventoryAggregatorMarshaller();

    public static InventoryAggregatorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InventoryAggregator inventoryAggregator, ProtocolMarshaller protocolMarshaller) {
        if (inventoryAggregator == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inventoryAggregator.expression(), EXPRESSION_BINDING);
            protocolMarshaller.marshall(inventoryAggregator.aggregators(), AGGREGATORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

