/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.InventoryItem;

public class InventoryItemUnmarshaller
implements Unmarshaller<InventoryItem, JsonUnmarshallerContext> {
    private static final InventoryItemUnmarshaller INSTANCE = new InventoryItemUnmarshaller();

    public InventoryItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        InventoryItem.Builder inventoryItemBuilder = InventoryItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TypeName", targetDepth)) {
                    context.nextToken();
                    inventoryItemBuilder.typeName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SchemaVersion", targetDepth)) {
                    context.nextToken();
                    inventoryItemBuilder.schemaVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CaptureTime", targetDepth)) {
                    context.nextToken();
                    inventoryItemBuilder.captureTime((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentHash", targetDepth)) {
                    context.nextToken();
                    inventoryItemBuilder.contentHash((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Content", targetDepth)) {
                    context.nextToken();
                    inventoryItemBuilder.content(new ListUnmarshaller((Unmarshaller)new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("Context", targetDepth)) {
                    context.nextToken();
                    inventoryItemBuilder.context(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InventoryItem)inventoryItemBuilder.build();
    }

    public static InventoryItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

