/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.NonCompliantSummary;

@SdkInternalApi
public class NonCompliantSummaryMarshaller {
    private static final MarshallingInfo<Integer> NONCOMPLIANTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonCompliantCount").build();
    private static final MarshallingInfo<StructuredPojo> SEVERITYSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SeveritySummary").build();
    private static final NonCompliantSummaryMarshaller INSTANCE = new NonCompliantSummaryMarshaller();

    public static NonCompliantSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NonCompliantSummary nonCompliantSummary, ProtocolMarshaller protocolMarshaller) {
        if (nonCompliantSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)nonCompliantSummary.nonCompliantCount(), NONCOMPLIANTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)nonCompliantSummary.severitySummary(), SEVERITYSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

