/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ComplianceExecutionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the call execution that includes an execution ID, the type of execution (for example,
 * <code>Command</code>), and the date/time of the execution using a datetime object that is saved in the following
 * format: yyyy-MM-dd'T'HH:mm:ss'Z'.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ComplianceExecutionSummary implements StructuredPojo,
        ToCopyableBuilder<ComplianceExecutionSummary.Builder, ComplianceExecutionSummary> {
    private final Instant executionTime;

    private final String executionId;

    private final String executionType;

    private ComplianceExecutionSummary(BuilderImpl builder) {
        this.executionTime = builder.executionTime;
        this.executionId = builder.executionId;
        this.executionType = builder.executionType;
    }

    /**
     * <p>
     * The time the execution ran as a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
     * </p>
     * 
     * @return The time the execution ran as a datetime object that is saved in the following format:
     *         yyyy-MM-dd'T'HH:mm:ss'Z'.
     */
    public Instant executionTime() {
        return executionTime;
    }

    /**
     * <p>
     * An ID created by the system when <code>PutComplianceItems</code> was called. For example, <code>CommandID</code>
     * is a valid execution ID. You can use this ID in subsequent calls.
     * </p>
     * 
     * @return An ID created by the system when <code>PutComplianceItems</code> was called. For example,
     *         <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.
     */
    public String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The type of execution. For example, <code>Command</code> is a valid execution type.
     * </p>
     * 
     * @return The type of execution. For example, <code>Command</code> is a valid execution type.
     */
    public String executionType() {
        return executionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(executionType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceExecutionSummary)) {
            return false;
        }
        ComplianceExecutionSummary other = (ComplianceExecutionSummary) obj;
        return Objects.equals(executionTime(), other.executionTime()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(executionType(), other.executionType());
    }

    @Override
    public String toString() {
        return ToString.builder("ComplianceExecutionSummary").add("ExecutionTime", executionTime())
                .add("ExecutionId", executionId()).add("ExecutionType", executionType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionTime":
            return Optional.of(clazz.cast(executionTime()));
        case "ExecutionId":
            return Optional.of(clazz.cast(executionId()));
        case "ExecutionType":
            return Optional.of(clazz.cast(executionType()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceExecutionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ComplianceExecutionSummary> {
        /**
         * <p>
         * The time the execution ran as a datetime object that is saved in the following format:
         * yyyy-MM-dd'T'HH:mm:ss'Z'.
         * </p>
         * 
         * @param executionTime
         *        The time the execution ran as a datetime object that is saved in the following format:
         *        yyyy-MM-dd'T'HH:mm:ss'Z'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Instant executionTime);

        /**
         * <p>
         * An ID created by the system when <code>PutComplianceItems</code> was called. For example,
         * <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.
         * </p>
         * 
         * @param executionId
         *        An ID created by the system when <code>PutComplianceItems</code> was called. For example,
         *        <code>CommandID</code> is a valid execution ID. You can use this ID in subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The type of execution. For example, <code>Command</code> is a valid execution type.
         * </p>
         * 
         * @param executionType
         *        The type of execution. For example, <code>Command</code> is a valid execution type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionType(String executionType);
    }

    static final class BuilderImpl implements Builder {
        private Instant executionTime;

        private String executionId;

        private String executionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceExecutionSummary model) {
            executionTime(model.executionTime);
            executionId(model.executionId);
            executionType(model.executionType);
        }

        public final Instant getExecutionTime() {
            return executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        public final String getExecutionId() {
            return executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getExecutionType() {
            return executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public ComplianceExecutionSummary build() {
            return new ComplianceExecutionSummary(this);
        }
    }
}
