/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateMaintenanceWindowResponse extends SSMResponse implements
        ToCopyableBuilder<CreateMaintenanceWindowResponse.Builder, CreateMaintenanceWindowResponse> {
    private final String windowId;

    private CreateMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
    }

    /**
     * <p>
     * The ID of the created Maintenance Window.
     * </p>
     * 
     * @return The ID of the created Maintenance Window.
     */
    public String windowId() {
        return windowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMaintenanceWindowResponse)) {
            return false;
        }
        CreateMaintenanceWindowResponse other = (CreateMaintenanceWindowResponse) obj;
        return Objects.equals(windowId(), other.windowId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateMaintenanceWindowResponse").add("WindowId", windowId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, CreateMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the created Maintenance Window.
         * </p>
         * 
         * @param windowId
         *        The ID of the created Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String windowId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMaintenanceWindowResponse model) {
            windowId(model.windowId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public CreateMaintenanceWindowResponse build() {
            return new CreateMaintenanceWindowResponse(this);
        }
    }
}
