/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowExecutionsRequest extends SSMRequest implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionsRequest.Builder, DescribeMaintenanceWindowExecutionsRequest> {
    private final String windowId;

    private final List<MaintenanceWindowFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the Maintenance Window whose executions should be retrieved.
     * </p>
     * 
     * @return The ID of the Maintenance Window whose executions should be retrieved.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * Each entry in the array is a structure containing:
     * </p>
     * <p>
     * Key (string, between 1 and 128 characters)
     * </p>
     * <p>
     * Values (array of strings, each string is between 1 and 256 characters)
     * </p>
     * <p>
     * The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such as
     * 2016-11-04T05:00:00Z.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Each entry in the array is a structure containing:</p>
     *         <p>
     *         Key (string, between 1 and 128 characters)
     *         </p>
     *         <p>
     *         Values (array of strings, each string is between 1 and 256 characters)
     *         </p>
     *         <p>
     *         The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such as
     *         2016-11-04T05:00:00Z.
     */
    public List<MaintenanceWindowFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionsRequest)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionsRequest other = (DescribeMaintenanceWindowExecutionsRequest) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowExecutionsRequest").add("WindowId", windowId())
                .add("Filters", filters()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMRequest.Builder, CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionsRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window whose executions should be retrieved.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window whose executions should be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string is between 1 and 256 characters)
         * </p>
         * <p>
         * The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such as
         * 2016-11-04T05:00:00Z.
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string, between 1 and 128 characters)
         *        </p>
         *        <p>
         *        Values (array of strings, each string is between 1 and 256 characters)
         *        </p>
         *        <p>
         *        The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such
         *        as 2016-11-04T05:00:00Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<MaintenanceWindowFilter> filters);

        /**
         * <p>
         * Each entry in the array is a structure containing:
         * </p>
         * <p>
         * Key (string, between 1 and 128 characters)
         * </p>
         * <p>
         * Values (array of strings, each string is between 1 and 256 characters)
         * </p>
         * <p>
         * The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such as
         * 2016-11-04T05:00:00Z.
         * </p>
         * 
         * @param filters
         *        Each entry in the array is a structure containing:</p>
         *        <p>
         *        Key (string, between 1 and 128 characters)
         *        </p>
         *        <p>
         *        Values (array of strings, each string is between 1 and 256 characters)
         *        </p>
         *        <p>
         *        The supported Keys are ExecutedBefore and ExecutedAfter with the value being a date/time string such
         *        as 2016-11-04T05:00:00Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(MaintenanceWindowFilter... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends SSMRequest.BuilderImpl implements Builder {
        private String windowId;

        private List<MaintenanceWindowFilter> filters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionsRequest model) {
            windowId(model.windowId);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final Collection<MaintenanceWindowFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(MaintenanceWindowFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<MaintenanceWindowFilter> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(MaintenanceWindowFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<MaintenanceWindowFilter.BuilderImpl> filters) {
            this.filters = MaintenanceWindowFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeMaintenanceWindowExecutionsRequest build() {
            return new DescribeMaintenanceWindowExecutionsRequest(this);
        }
    }
}
