/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowsResponse extends SSMResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowsResponse.Builder, DescribeMaintenanceWindowsResponse> {
    private final List<MaintenanceWindowIdentity> windowIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.windowIdentities = builder.windowIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Maintenance Windows.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Maintenance Windows.
     */
    public List<MaintenanceWindowIdentity> windowIdentities() {
        return windowIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowsResponse other = (DescribeMaintenanceWindowsResponse) obj;
        return Objects.equals(windowIdentities(), other.windowIdentities()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowsResponse").add("WindowIdentities", windowIdentities())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowIdentities":
            return Optional.of(clazz.cast(windowIdentities()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, DescribeMaintenanceWindowsResponse> {
        /**
         * <p>
         * Information about the Maintenance Windows.
         * </p>
         * 
         * @param windowIdentities
         *        Information about the Maintenance Windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities);

        /**
         * <p>
         * Information about the Maintenance Windows.
         * </p>
         * 
         * @param windowIdentities
         *        Information about the Maintenance Windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowIdentities(MaintenanceWindowIdentity... windowIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowIdentity> windowIdentities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsResponse model) {
            windowIdentities(model.windowIdentities);
            nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowIdentity.Builder> getWindowIdentities() {
            return windowIdentities != null ? windowIdentities.stream().map(MaintenanceWindowIdentity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copy(windowIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(MaintenanceWindowIdentity... windowIdentities) {
            windowIdentities(Arrays.asList(windowIdentities));
            return this;
        }

        public final void setWindowIdentities(Collection<MaintenanceWindowIdentity.BuilderImpl> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copyFromBuilder(windowIdentities);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowsResponse build() {
            return new DescribeMaintenanceWindowsResponse(this);
        }
    }
}
