/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDefaultPatchBaselineResponse extends SSMResponse implements
        ToCopyableBuilder<GetDefaultPatchBaselineResponse.Builder, GetDefaultPatchBaselineResponse> {
    private final String baselineId;

    private final String operatingSystem;

    private GetDefaultPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.operatingSystem = builder.operatingSystem;
    }

    /**
     * <p>
     * The ID of the default patch baseline.
     * </p>
     * 
     * @return The ID of the default patch baseline.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The operating system for the returned patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemString}.
     * </p>
     * 
     * @return The operating system for the returned patch baseline.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The operating system for the returned patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemString}.
     * </p>
     * 
     * @return The operating system for the returned patch baseline.
     * @see OperatingSystem
     */
    public String operatingSystemString() {
        return operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultPatchBaselineResponse)) {
            return false;
        }
        GetDefaultPatchBaselineResponse other = (GetDefaultPatchBaselineResponse) obj;
        return Objects.equals(baselineId(), other.baselineId())
                && Objects.equals(operatingSystemString(), other.operatingSystemString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDefaultPatchBaselineResponse").add("BaselineId", baselineId())
                .add("OperatingSystem", operatingSystemString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.of(clazz.cast(baselineId()));
        case "OperatingSystem":
            return Optional.of(clazz.cast(operatingSystemString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, GetDefaultPatchBaselineResponse> {
        /**
         * <p>
         * The ID of the default patch baseline.
         * </p>
         * 
         * @param baselineId
         *        The ID of the default patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The operating system for the returned patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system for the returned patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The operating system for the returned patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system for the returned patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private String baselineId;

        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultPatchBaselineResponse model) {
            baselineId(model.baselineId);
            operatingSystem(model.operatingSystem);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public GetDefaultPatchBaselineResponse build() {
            return new GetDefaultPatchBaselineResponse(this);
        }
    }
}
