/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCommandInvocationsResponse extends SSMResponse implements
        ToCopyableBuilder<ListCommandInvocationsResponse.Builder, ListCommandInvocationsResponse> {
    private final List<CommandInvocation> commandInvocations;

    private final String nextToken;

    private ListCommandInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.commandInvocations = builder.commandInvocations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * (Optional) A list of all invocations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) A list of all invocations.
     */
    public List<CommandInvocation> commandInvocations() {
        return commandInvocations;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsResponse)) {
            return false;
        }
        ListCommandInvocationsResponse other = (ListCommandInvocationsResponse) obj;
        return Objects.equals(commandInvocations(), other.commandInvocations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCommandInvocationsResponse").add("CommandInvocations", commandInvocations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandInvocations":
            return Optional.of(clazz.cast(commandInvocations()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, ListCommandInvocationsResponse> {
        /**
         * <p>
         * (Optional) A list of all invocations.
         * </p>
         * 
         * @param commandInvocations
         *        (Optional) A list of all invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandInvocations(Collection<CommandInvocation> commandInvocations);

        /**
         * <p>
         * (Optional) A list of all invocations.
         * </p>
         * 
         * @param commandInvocations
         *        (Optional) A list of all invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandInvocations(CommandInvocation... commandInvocations);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private List<CommandInvocation> commandInvocations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandInvocationsResponse model) {
            commandInvocations(model.commandInvocations);
            nextToken(model.nextToken);
        }

        public final Collection<CommandInvocation.Builder> getCommandInvocations() {
            return commandInvocations != null ? commandInvocations.stream().map(CommandInvocation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commandInvocations(Collection<CommandInvocation> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copy(commandInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandInvocations(CommandInvocation... commandInvocations) {
            commandInvocations(Arrays.asList(commandInvocations));
            return this;
        }

        public final void setCommandInvocations(Collection<CommandInvocation.BuilderImpl> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copyFromBuilder(commandInvocations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCommandInvocationsResponse build() {
            return new ListCommandInvocationsResponse(this);
        }
    }
}
