/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SendCommandResponse extends SSMResponse implements
        ToCopyableBuilder<SendCommandResponse.Builder, SendCommandResponse> {
    private final Command command;

    private SendCommandResponse(BuilderImpl builder) {
        super(builder);
        this.command = builder.command;
    }

    /**
     * <p>
     * The request as it was received by Systems Manager. Also provides the command ID which can be used future
     * references to this request.
     * </p>
     * 
     * @return The request as it was received by Systems Manager. Also provides the command ID which can be used future
     *         references to this request.
     */
    public Command command() {
        return command;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(command());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandResponse)) {
            return false;
        }
        SendCommandResponse other = (SendCommandResponse) obj;
        return Objects.equals(command(), other.command());
    }

    @Override
    public String toString() {
        return ToString.builder("SendCommandResponse").add("Command", command()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Command":
            return Optional.of(clazz.cast(command()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SSMResponse.Builder, CopyableBuilder<Builder, SendCommandResponse> {
        /**
         * <p>
         * The request as it was received by Systems Manager. Also provides the command ID which can be used future
         * references to this request.
         * </p>
         * 
         * @param command
         *        The request as it was received by Systems Manager. Also provides the command ID which can be used
         *        future references to this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Command command);

        /**
         * <p>
         * The request as it was received by Systems Manager. Also provides the command ID which can be used future
         * references to this request.
         * </p>
         * This is a convenience that creates an instance of the {@link Command.Builder} avoiding the need to create one
         * manually via {@link Command#builder()}.
         *
         * When the {@link Consumer} completes, {@link Command.Builder#build()} is called immediately and its result is
         * passed to {@link #command(Command)}.
         * 
         * @param command
         *        a consumer that will call methods on {@link Command.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #command(Command)
         */
        default Builder command(Consumer<Command.Builder> command) {
            return command(Command.builder().apply(command).build());
        }
    }

    static final class BuilderImpl extends SSMResponse.BuilderImpl implements Builder {
        private Command command;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandResponse model) {
            command(model.command);
        }

        public final Command.Builder getCommand() {
            return command != null ? command.toBuilder() : null;
        }

        @Override
        public final Builder command(Command command) {
            this.command = command;
            return this;
        }

        public final void setCommand(Command.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public SendCommandResponse build() {
            return new SendCommandResponse(this);
        }
    }
}
