/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link AssociationDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class AssociationDescriptionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();

    private static final MarshallingInfo<Instant> DATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Date").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEASSOCIATIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastUpdateAssociationDate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> OVERVIEW_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Overview").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();

    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();

    private static final MarshallingInfo<String> SCHEDULEEXPRESSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScheduleExpression").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> OUTPUTLOCATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("OutputLocation").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTEXECUTIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastExecutionDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSUCCESSFULEXECUTIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulExecutionDate").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationName").isBinary(false).build();

    private static final AssociationDescriptionMarshaller INSTANCE = new AssociationDescriptionMarshaller();

    private AssociationDescriptionMarshaller() {
    }

    public static AssociationDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(AssociationDescription associationDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(associationDescription, "associationDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(associationDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall(associationDescription.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(associationDescription.associationVersion(), ASSOCIATIONVERSION_BINDING);
            protocolMarshaller.marshall(associationDescription.date(), DATE_BINDING);
            protocolMarshaller.marshall(associationDescription.lastUpdateAssociationDate(), LASTUPDATEASSOCIATIONDATE_BINDING);
            protocolMarshaller.marshall(associationDescription.status(), STATUS_BINDING);
            protocolMarshaller.marshall(associationDescription.overview(), OVERVIEW_BINDING);
            protocolMarshaller.marshall(associationDescription.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(associationDescription.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(associationDescription.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall(associationDescription.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(associationDescription.scheduleExpression(), SCHEDULEEXPRESSION_BINDING);
            protocolMarshaller.marshall(associationDescription.outputLocation(), OUTPUTLOCATION_BINDING);
            protocolMarshaller.marshall(associationDescription.lastExecutionDate(), LASTEXECUTIONDATE_BINDING);
            protocolMarshaller
                    .marshall(associationDescription.lastSuccessfulExecutionDate(), LASTSUCCESSFULEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall(associationDescription.associationName(), ASSOCIATIONNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
