/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreatePatchBaselineRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreatePatchBaselineRequestModelMarshaller {
    private static final MarshallingInfo<String> OPERATINGSYSTEM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperatingSystem").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> GLOBALFILTERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalFilters")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> APPROVALRULES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovalRules")
            .isBinary(false).build();

    private static final MarshallingInfo<List> APPROVEDPATCHES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovedPatches").isBinary(false).build();

    private static final MarshallingInfo<String> APPROVEDPATCHESCOMPLIANCELEVEL_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ApprovedPatchesComplianceLevel").isBinary(false).build();

    private static final MarshallingInfo<List> REJECTEDPATCHES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RejectedPatches").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").isBinary(false)
            .defaultValueSupplier(IdempotentUtils.getGenerator()).build();

    private static final CreatePatchBaselineRequestModelMarshaller INSTANCE = new CreatePatchBaselineRequestModelMarshaller();

    private CreatePatchBaselineRequestModelMarshaller() {
    }

    public static CreatePatchBaselineRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreatePatchBaselineRequest createPatchBaselineRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createPatchBaselineRequest, "createPatchBaselineRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createPatchBaselineRequest.operatingSystemString(), OPERATINGSYSTEM_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.globalFilters(), GLOBALFILTERS_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.approvalRules(), APPROVALRULES_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.approvedPatches(), APPROVEDPATCHES_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.approvedPatchesComplianceLevelString(),
                    APPROVEDPATCHESCOMPLIANCELEVEL_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.rejectedPatches(), REJECTEDPATCHES_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createPatchBaselineRequest.clientToken(), CLIENTTOKEN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
