/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstanceInformation} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceInformationMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<String> PINGSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PingStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTPINGDATETIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastPingDateTime").isBinary(false).build();

    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ISLATESTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsLatestVersion").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORMTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformType").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformName").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").isBinary(false).build();

    private static final MarshallingInfo<String> ACTIVATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationId").isBinary(false).build();

    private static final MarshallingInfo<String> IAMROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").isBinary(false).build();

    private static final MarshallingInfo<Instant> REGISTRATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegistrationDate").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IPAddress").isBinary(false).build();

    private static final MarshallingInfo<String> COMPUTERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerName").isBinary(false).build();

    private static final MarshallingInfo<String> ASSOCIATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationStatus").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastAssociationExecutionDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("LastSuccessfulAssociationExecutionDate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ASSOCIATIONOVERVIEW_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("AssociationOverview").isBinary(false).build();

    private static final InstanceInformationMarshaller INSTANCE = new InstanceInformationMarshaller();

    private InstanceInformationMarshaller() {
    }

    public static InstanceInformationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstanceInformation instanceInformation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instanceInformation, "instanceInformation");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instanceInformation.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(instanceInformation.pingStatusString(), PINGSTATUS_BINDING);
            protocolMarshaller.marshall(instanceInformation.lastPingDateTime(), LASTPINGDATETIME_BINDING);
            protocolMarshaller.marshall(instanceInformation.agentVersion(), AGENTVERSION_BINDING);
            protocolMarshaller.marshall(instanceInformation.isLatestVersion(), ISLATESTVERSION_BINDING);
            protocolMarshaller.marshall(instanceInformation.platformTypeString(), PLATFORMTYPE_BINDING);
            protocolMarshaller.marshall(instanceInformation.platformName(), PLATFORMNAME_BINDING);
            protocolMarshaller.marshall(instanceInformation.platformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall(instanceInformation.activationId(), ACTIVATIONID_BINDING);
            protocolMarshaller.marshall(instanceInformation.iamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall(instanceInformation.registrationDate(), REGISTRATIONDATE_BINDING);
            protocolMarshaller.marshall(instanceInformation.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(instanceInformation.name(), NAME_BINDING);
            protocolMarshaller.marshall(instanceInformation.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall(instanceInformation.computerName(), COMPUTERNAME_BINDING);
            protocolMarshaller.marshall(instanceInformation.associationStatus(), ASSOCIATIONSTATUS_BINDING);
            protocolMarshaller.marshall(instanceInformation.lastAssociationExecutionDate(), LASTASSOCIATIONEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall(instanceInformation.lastSuccessfulAssociationExecutionDate(),
                    LASTSUCCESSFULASSOCIATIONEXECUTIONDATE_BINDING);
            protocolMarshaller.marshall(instanceInformation.associationOverview(), ASSOCIATIONOVERVIEW_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
