/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InstancePatchState} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstancePatchStateMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();

    private static final MarshallingInfo<String> PATCHGROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PatchGroup").isBinary(false).build();

    private static final MarshallingInfo<String> BASELINEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaselineId").isBinary(false).build();

    private static final MarshallingInfo<String> SNAPSHOTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotId").isBinary(false).build();

    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").isBinary(false).build();

    private static final MarshallingInfo<Integer> INSTALLEDCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> INSTALLEDOTHERCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledOtherCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> MISSINGCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> FAILEDCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailedCount").isBinary(false).build();

    private static final MarshallingInfo<Integer> NOTAPPLICABLECOUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotApplicableCount").isBinary(false).build();

    private static final MarshallingInfo<Instant> OPERATIONSTARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationStartTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> OPERATIONENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OperationEndTime").isBinary(false).build();

    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").isBinary(false).build();

    private static final InstancePatchStateMarshaller INSTANCE = new InstancePatchStateMarshaller();

    private InstancePatchStateMarshaller() {
    }

    public static InstancePatchStateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InstancePatchState instancePatchState, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instancePatchState, "instancePatchState");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instancePatchState.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(instancePatchState.patchGroup(), PATCHGROUP_BINDING);
            protocolMarshaller.marshall(instancePatchState.baselineId(), BASELINEID_BINDING);
            protocolMarshaller.marshall(instancePatchState.snapshotId(), SNAPSHOTID_BINDING);
            protocolMarshaller.marshall(instancePatchState.ownerInformation(), OWNERINFORMATION_BINDING);
            protocolMarshaller.marshall(instancePatchState.installedCount(), INSTALLEDCOUNT_BINDING);
            protocolMarshaller.marshall(instancePatchState.installedOtherCount(), INSTALLEDOTHERCOUNT_BINDING);
            protocolMarshaller.marshall(instancePatchState.missingCount(), MISSINGCOUNT_BINDING);
            protocolMarshaller.marshall(instancePatchState.failedCount(), FAILEDCOUNT_BINDING);
            protocolMarshaller.marshall(instancePatchState.notApplicableCount(), NOTAPPLICABLECOUNT_BINDING);
            protocolMarshaller.marshall(instancePatchState.operationStartTime(), OPERATIONSTARTTIME_BINDING);
            protocolMarshaller.marshall(instancePatchState.operationEndTime(), OPERATIONENDTIME_BINDING);
            protocolMarshaller.marshall(instancePatchState.operationString(), OPERATION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
