/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateMaintenanceWindowTaskRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateMaintenanceWindowTaskRequestModelMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();

    private static final MarshallingInfo<String> WINDOWTASKID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTaskId").isBinary(false).build();

    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();

    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").isBinary(false).build();

    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();

    private static final MarshallingInfo<Map> TASKPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskParameters").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TASKINVOCATIONPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("TaskInvocationParameters").isBinary(false).build();

    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").isBinary(false).build();

    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").isBinary(false).build();

    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOGGINGINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggingInfo")
            .isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REPLACE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Replace").isBinary(false).build();

    private static final UpdateMaintenanceWindowTaskRequestModelMarshaller INSTANCE = new UpdateMaintenanceWindowTaskRequestModelMarshaller();

    private UpdateMaintenanceWindowTaskRequestModelMarshaller() {
    }

    public static UpdateMaintenanceWindowTaskRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateMaintenanceWindowTaskRequest updateMaintenanceWindowTaskRequest,
            ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateMaintenanceWindowTaskRequest, "updateMaintenanceWindowTaskRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.windowTaskId(), WINDOWTASKID_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskParameters(), TASKPARAMETERS_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.taskInvocationParameters(),
                    TASKINVOCATIONPARAMETERS_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.loggingInfo(), LOGGINGINFO_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateMaintenanceWindowTaskRequest.replace(), REPLACE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
