/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowRunCommandParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowRunCommandParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowRunCommandParameters> {
    private final String comment;
    private final String documentHash;
    private final String documentHashType;
    private final NotificationConfig notificationConfig;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final Map<String, List<String>> parameters;
    private final String serviceRoleArn;
    private final Integer timeoutSeconds;

    private MaintenanceWindowRunCommandParameters(BuilderImpl builder) {
        this.comment = builder.comment;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.notificationConfig = builder.notificationConfig;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.parameters = builder.parameters;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    public String comment() {
        return this.comment;
    }

    public String documentHash() {
        return this.documentHash;
    }

    public DocumentHashType documentHashType() {
        return DocumentHashType.fromValue(this.documentHashType);
    }

    public String documentHashTypeString() {
        return this.documentHashType;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentHashTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowRunCommandParameters)) {
            return false;
        }
        MaintenanceWindowRunCommandParameters other = (MaintenanceWindowRunCommandParameters)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.documentHash(), other.documentHash()) && Objects.equals(this.documentHashTypeString(), other.documentHashTypeString()) && Objects.equals(this.notificationConfig(), other.notificationConfig()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceWindowRunCommandParameters").add("Comment", (Object)this.comment()).add("DocumentHash", (Object)this.documentHash()).add("DocumentHashType", (Object)this.documentHashTypeString()).add("NotificationConfig", (Object)this.notificationConfig()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("Parameters", this.parameters()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "DocumentHash": {
                return Optional.of(clazz.cast(this.documentHash()));
            }
            case "DocumentHashType": {
                return Optional.of(clazz.cast(this.documentHashTypeString()));
            }
            case "NotificationConfig": {
                return Optional.of(clazz.cast(this.notificationConfig()));
            }
            case "OutputS3BucketName": {
                return Optional.of(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.of(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "ServiceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "TimeoutSeconds": {
                return Optional.of(clazz.cast(this.timeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowRunCommandParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String documentHash;
        private String documentHashType;
        private NotificationConfig notificationConfig;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private Map<String, List<String>> parameters;
        private String serviceRoleArn;
        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowRunCommandParameters model) {
            this.comment(model.comment);
            this.documentHash(model.documentHash);
            this.documentHashType(model.documentHashType);
            this.notificationConfig(model.notificationConfig);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.parameters(model.parameters);
            this.serviceRoleArn(model.serviceRoleArn);
            this.timeoutSeconds(model.timeoutSeconds);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentHash() {
            return this.documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        public final String getDocumentHashType() {
            return this.documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
            return this;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public MaintenanceWindowRunCommandParameters build() {
            return new MaintenanceWindowRunCommandParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowRunCommandParameters> {
        public Builder comment(String var1);

        public Builder documentHash(String var1);

        public Builder documentHashType(String var1);

        public Builder documentHashType(DocumentHashType var1);

        public Builder notificationConfig(NotificationConfig var1);

        default public Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((NotificationConfig)((NotificationConfig.Builder)NotificationConfig.builder().apply(notificationConfig)).build());
        }

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder serviceRoleArn(String var1);

        public Builder timeoutSeconds(Integer var1);
    }
}

