/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.AssociationStatus;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateAssociationStatusRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, UpdateAssociationStatusRequest> {
    private final String name;
    private final String instanceId;
    private final AssociationStatus associationStatus;

    private UpdateAssociationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationStatus = builder.associationStatus;
    }

    public String name() {
        return this.name;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public AssociationStatus associationStatus() {
        return this.associationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationStatusRequest)) {
            return false;
        }
        UpdateAssociationStatusRequest other = (UpdateAssociationStatusRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.associationStatus(), other.associationStatus());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAssociationStatusRequest").add("Name", (Object)this.name()).add("InstanceId", (Object)this.instanceId()).add("AssociationStatus", (Object)this.associationStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "AssociationStatus": {
                return Optional.of(clazz.cast(this.associationStatus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private AssociationStatus associationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationStatusRequest model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.associationStatus(model.associationStatus);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final AssociationStatus.Builder getAssociationStatus() {
            return this.associationStatus != null ? this.associationStatus.toBuilder() : null;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(AssociationStatus.BuilderImpl associationStatus) {
            this.associationStatus = associationStatus != null ? associationStatus.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssociationStatusRequest build() {
            return new UpdateAssociationStatusRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, UpdateAssociationStatusRequest> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder associationStatus(AssociationStatus var1);

        default public Builder associationStatus(Consumer<AssociationStatus.Builder> associationStatus) {
            return this.associationStatus((AssociationStatus)((AssociationStatus.Builder)AssociationStatus.builder().apply(associationStatus)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

