/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ssm.SSMAsyncClient;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;

public class DescribeParametersPublisher
implements SdkPublisher<DescribeParametersResponse> {
    private final SSMAsyncClient client;
    private final DescribeParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeParametersPublisher(SSMAsyncClient client, DescribeParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeParametersPublisher(SSMAsyncClient client, DescribeParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final DescribeParametersPublisher resume(DescribeParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeParametersPublisher(this.client, (DescribeParametersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeParametersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeParametersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeParametersResponseFetcher
    implements AsyncPageFetcher<DescribeParametersResponse> {
        private DescribeParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeParametersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeParametersResponse> nextPage(DescribeParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeParametersPublisher.this.client.describeParameters(DescribeParametersPublisher.this.firstRequest);
            }
            return DescribeParametersPublisher.this.client.describeParameters((DescribeParametersRequest)((Object)DescribeParametersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

