/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.Association;
import software.amazon.awssdk.services.ssm.transform.AssociationOverviewUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.TargetUnmarshaller;

public class AssociationUnmarshaller
implements Unmarshaller<Association, JsonUnmarshallerContext> {
    private static final AssociationUnmarshaller INSTANCE = new AssociationUnmarshaller();

    public Association unmarshall(JsonUnmarshallerContext context) throws Exception {
        Association.Builder associationBuilder = Association.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    associationBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    associationBuilder.instanceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssociationId", targetDepth)) {
                    context.nextToken();
                    associationBuilder.associationId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssociationVersion", targetDepth)) {
                    context.nextToken();
                    associationBuilder.associationVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DocumentVersion", targetDepth)) {
                    context.nextToken();
                    associationBuilder.documentVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    associationBuilder.targets(new ListUnmarshaller((Unmarshaller)TargetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("LastExecutionDate", targetDepth)) {
                    context.nextToken();
                    associationBuilder.lastExecutionDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Overview", targetDepth)) {
                    context.nextToken();
                    associationBuilder.overview(AssociationOverviewUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ScheduleExpression", targetDepth)) {
                    context.nextToken();
                    associationBuilder.scheduleExpression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AssociationName", targetDepth)) {
                    context.nextToken();
                    associationBuilder.associationName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Association)associationBuilder.build();
    }

    public static AssociationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

