/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AutomationExecution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutomationExecutionMarshaller {
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStartTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionStatus").isBinary(false).build();
    private static final MarshallingInfo<List> STEPEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepExecutions").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").isBinary(false).build();
    private static final AutomationExecutionMarshaller INSTANCE = new AutomationExecutionMarshaller();

    private AutomationExecutionMarshaller() {
    }

    public static AutomationExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutomationExecution automationExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)automationExecution, (String)"automationExecution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)automationExecution.automationExecutionId(), AUTOMATIONEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.executionStartTime(), EXECUTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.executionEndTime(), EXECUTIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.automationExecutionStatusString(), AUTOMATIONEXECUTIONSTATUS_BINDING);
            protocolMarshaller.marshall(automationExecution.stepExecutions(), STEPEXECUTIONS_BINDING);
            protocolMarshaller.marshall(automationExecution.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(automationExecution.outputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.failureMessage(), FAILUREMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

