/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeInstancePatchesRequestModelMarshaller {
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<List> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final DescribeInstancePatchesRequestModelMarshaller INSTANCE = new DescribeInstancePatchesRequestModelMarshaller();

    private DescribeInstancePatchesRequestModelMarshaller() {
    }

    public static DescribeInstancePatchesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeInstancePatchesRequest describeInstancePatchesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeInstancePatchesRequest), (String)"describeInstancePatchesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeInstancePatchesRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall(describeInstancePatchesRequest.filters(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)describeInstancePatchesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)describeInstancePatchesRequest.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

