/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MaintenanceWindowAutomationParametersMarshaller {
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MaintenanceWindowAutomationParametersMarshaller INSTANCE = new MaintenanceWindowAutomationParametersMarshaller();

    private MaintenanceWindowAutomationParametersMarshaller() {
    }

    public static MaintenanceWindowAutomationParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowAutomationParameters maintenanceWindowAutomationParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)maintenanceWindowAutomationParameters, (String)"maintenanceWindowAutomationParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowAutomationParameters.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall(maintenanceWindowAutomationParameters.parameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

