/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateActivationRequest extends SsmRequest implements
        ToCopyableBuilder<CreateActivationRequest.Builder, CreateActivationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateActivationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateActivationRequest::defaultInstanceName)).setter(setter(Builder::defaultInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceName").build())
            .build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateActivationRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<Integer> REGISTRATION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateActivationRequest::registrationLimit)).setter(setter(Builder::registrationLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationLimit").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateActivationRequest::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DEFAULT_INSTANCE_NAME_FIELD, IAM_ROLE_FIELD, REGISTRATION_LIMIT_FIELD, EXPIRATION_DATE_FIELD));

    private final String description;

    private final String defaultInstanceName;

    private final String iamRole;

    private final Integer registrationLimit;

    private final Instant expirationDate;

    private CreateActivationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * A user-defined description of the resource that you want to register with Amazon EC2.
     * </p>
     * <important>
     * <p>
     * Do not enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @return A user-defined description of the resource that you want to register with Amazon EC2. </p> <important>
     *         <p>
     *         Do not enter personally identifiable information in this field.
     *         </p>
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use the AWS
     * command line tools to list EC2 resources.
     * </p>
     * <important>
     * <p>
     * Do not enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @return The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use
     *         the AWS command line tools to list EC2 resources.</p> <important>
     *         <p>
     *         Do not enter personally identifiable information in this field.
     *         </p>
     */
    public String defaultInstanceName() {
        return defaultInstanceName;
    }

    /**
     * <p>
     * The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
     * </p>
     * 
     * @return The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * Specify the maximum number of managed instances you want to register. The default value is 1 instance.
     * </p>
     * 
     * @return Specify the maximum number of managed instances you want to register. The default value is 1 instance.
     */
    public Integer registrationLimit() {
        return registrationLimit;
    }

    /**
     * <p>
     * The date by which this activation request should expire. The default value is 24 hours.
     * </p>
     * 
     * @return The date by which this activation request should expire. The default value is 24 hours.
     */
    public Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationRequest)) {
            return false;
        }
        CreateActivationRequest other = (CreateActivationRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(defaultInstanceName(), other.defaultInstanceName())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(registrationLimit(), other.registrationLimit())
                && Objects.equals(expirationDate(), other.expirationDate());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateActivationRequest").add("Description", description())
                .add("DefaultInstanceName", defaultInstanceName()).add("IamRole", iamRole())
                .add("RegistrationLimit", registrationLimit()).add("ExpirationDate", expirationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultInstanceName":
            return Optional.ofNullable(clazz.cast(defaultInstanceName()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "RegistrationLimit":
            return Optional.ofNullable(clazz.cast(registrationLimit()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateActivationRequest, T> g) {
        return obj -> g.apply((CreateActivationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateActivationRequest> {
        /**
         * <p>
         * A user-defined description of the resource that you want to register with Amazon EC2.
         * </p>
         * <important>
         * <p>
         * Do not enter personally identifiable information in this field.
         * </p>
         * </important>
         * 
         * @param description
         *        A user-defined description of the resource that you want to register with Amazon EC2. </p> <important>
         *        <p>
         *        Do not enter personally identifiable information in this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you use the
         * AWS command line tools to list EC2 resources.
         * </p>
         * <important>
         * <p>
         * Do not enter personally identifiable information in this field.
         * </p>
         * </important>
         * 
         * @param defaultInstanceName
         *        The name of the registered, managed instance as it will appear in the Amazon EC2 console or when you
         *        use the AWS command line tools to list EC2 resources.</p> <important>
         *        <p>
         *        Do not enter personally identifiable information in this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceName(String defaultInstanceName);

        /**
         * <p>
         * The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
         * </p>
         * 
         * @param iamRole
         *        The Amazon Identity and Access Management (IAM) role that you want to assign to the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * Specify the maximum number of managed instances you want to register. The default value is 1 instance.
         * </p>
         * 
         * @param registrationLimit
         *        Specify the maximum number of managed instances you want to register. The default value is 1 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationLimit(Integer registrationLimit);

        /**
         * <p>
         * The date by which this activation request should expire. The default value is 24 hours.
         * </p>
         * 
         * @param expirationDate
         *        The date by which this activation request should expire. The default value is 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String description;

        private String defaultInstanceName;

        private String iamRole;

        private Integer registrationLimit;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationRequest model) {
            super(model);
            description(model.description);
            defaultInstanceName(model.defaultInstanceName);
            iamRole(model.iamRole);
            registrationLimit(model.registrationLimit);
            expirationDate(model.expirationDate);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultInstanceName() {
            return defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Integer getRegistrationLimit() {
            return registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateActivationRequest build() {
            return new CreateActivationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
