/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeDocumentResponse.Builder, DescribeDocumentResponse> {
    private static final SdkField<DocumentDescription> DOCUMENT_FIELD = SdkField
            .<DocumentDescription> builder(MarshallingType.SDK_POJO).getter(getter(DescribeDocumentResponse::document))
            .setter(setter(Builder::document)).constructor(DocumentDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD));

    private final DocumentDescription document;

    private DescribeDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
    }

    /**
     * <p>
     * Information about the Systems Manager document.
     * </p>
     * 
     * @return Information about the Systems Manager document.
     */
    public DocumentDescription document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentResponse)) {
            return false;
        }
        DescribeDocumentResponse other = (DescribeDocumentResponse) obj;
        return Objects.equals(document(), other.document());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDocumentResponse").add("Document", document()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Document":
            return Optional.ofNullable(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentResponse, T> g) {
        return obj -> g.apply((DescribeDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDocumentResponse> {
        /**
         * <p>
         * Information about the Systems Manager document.
         * </p>
         * 
         * @param document
         *        Information about the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentDescription document);

        /**
         * <p>
         * Information about the Systems Manager document.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentDescription.Builder} avoiding the need
         * to create one manually via {@link DocumentDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #document(DocumentDescription)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DocumentDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DocumentDescription)
         */
        default Builder document(Consumer<DocumentDescription.Builder> document) {
            return document(DocumentDescription.builder().applyMutation(document).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private DocumentDescription document;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentResponse model) {
            super(model);
            document(model.document);
        }

        public final DocumentDescription.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        @Override
        public final Builder document(DocumentDescription document) {
            this.document = document;
            return this;
        }

        public final void setDocument(DocumentDescription.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public DescribeDocumentResponse build() {
            return new DescribeDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
