/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for task execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowTaskInvocationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindowTaskInvocationParameters.Builder, MaintenanceWindowTaskInvocationParameters> {
    private static final SdkField<MaintenanceWindowRunCommandParameters> RUN_COMMAND_FIELD = SdkField
            .<MaintenanceWindowRunCommandParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(MaintenanceWindowTaskInvocationParameters::runCommand)).setter(setter(Builder::runCommand))
            .constructor(MaintenanceWindowRunCommandParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCommand").build()).build();

    private static final SdkField<MaintenanceWindowAutomationParameters> AUTOMATION_FIELD = SdkField
            .<MaintenanceWindowAutomationParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(MaintenanceWindowTaskInvocationParameters::automation)).setter(setter(Builder::automation))
            .constructor(MaintenanceWindowAutomationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final SdkField<MaintenanceWindowStepFunctionsParameters> STEP_FUNCTIONS_FIELD = SdkField
            .<MaintenanceWindowStepFunctionsParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(MaintenanceWindowTaskInvocationParameters::stepFunctions)).setter(setter(Builder::stepFunctions))
            .constructor(MaintenanceWindowStepFunctionsParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepFunctions").build()).build();

    private static final SdkField<MaintenanceWindowLambdaParameters> LAMBDA_FIELD = SdkField
            .<MaintenanceWindowLambdaParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(MaintenanceWindowTaskInvocationParameters::lambda)).setter(setter(Builder::lambda))
            .constructor(MaintenanceWindowLambdaParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_COMMAND_FIELD,
            AUTOMATION_FIELD, STEP_FUNCTIONS_FIELD, LAMBDA_FIELD));

    private static final long serialVersionUID = 1L;

    private final MaintenanceWindowRunCommandParameters runCommand;

    private final MaintenanceWindowAutomationParameters automation;

    private final MaintenanceWindowStepFunctionsParameters stepFunctions;

    private final MaintenanceWindowLambdaParameters lambda;

    private MaintenanceWindowTaskInvocationParameters(BuilderImpl builder) {
        this.runCommand = builder.runCommand;
        this.automation = builder.automation;
        this.stepFunctions = builder.stepFunctions;
        this.lambda = builder.lambda;
    }

    /**
     * <p>
     * The parameters for a RUN_COMMAND task type.
     * </p>
     * 
     * @return The parameters for a RUN_COMMAND task type.
     */
    public MaintenanceWindowRunCommandParameters runCommand() {
        return runCommand;
    }

    /**
     * <p>
     * The parameters for an AUTOMATION task type.
     * </p>
     * 
     * @return The parameters for an AUTOMATION task type.
     */
    public MaintenanceWindowAutomationParameters automation() {
        return automation;
    }

    /**
     * <p>
     * The parameters for a STEP_FUNCTION task type.
     * </p>
     * 
     * @return The parameters for a STEP_FUNCTION task type.
     */
    public MaintenanceWindowStepFunctionsParameters stepFunctions() {
        return stepFunctions;
    }

    /**
     * <p>
     * The parameters for a LAMBDA task type.
     * </p>
     * 
     * @return The parameters for a LAMBDA task type.
     */
    public MaintenanceWindowLambdaParameters lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runCommand());
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        hashCode = 31 * hashCode + Objects.hashCode(stepFunctions());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskInvocationParameters)) {
            return false;
        }
        MaintenanceWindowTaskInvocationParameters other = (MaintenanceWindowTaskInvocationParameters) obj;
        return Objects.equals(runCommand(), other.runCommand()) && Objects.equals(automation(), other.automation())
                && Objects.equals(stepFunctions(), other.stepFunctions()) && Objects.equals(lambda(), other.lambda());
    }

    @Override
    public String toString() {
        return ToString.builder("MaintenanceWindowTaskInvocationParameters").add("RunCommand", runCommand())
                .add("Automation", automation()).add("StepFunctions", stepFunctions()).add("Lambda", lambda()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunCommand":
            return Optional.ofNullable(clazz.cast(runCommand()));
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        case "StepFunctions":
            return Optional.ofNullable(clazz.cast(stepFunctions()));
        case "Lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowTaskInvocationParameters, T> g) {
        return obj -> g.apply((MaintenanceWindowTaskInvocationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindowTaskInvocationParameters> {
        /**
         * <p>
         * The parameters for a RUN_COMMAND task type.
         * </p>
         * 
         * @param runCommand
         *        The parameters for a RUN_COMMAND task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCommand(MaintenanceWindowRunCommandParameters runCommand);

        /**
         * <p>
         * The parameters for a RUN_COMMAND task type.
         * </p>
         * This is a convenience that creates an instance of the {@link MaintenanceWindowRunCommandParameters.Builder}
         * avoiding the need to create one manually via {@link MaintenanceWindowRunCommandParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowRunCommandParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #runCommand(MaintenanceWindowRunCommandParameters)}.
         * 
         * @param runCommand
         *        a consumer that will call methods on {@link MaintenanceWindowRunCommandParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runCommand(MaintenanceWindowRunCommandParameters)
         */
        default Builder runCommand(Consumer<MaintenanceWindowRunCommandParameters.Builder> runCommand) {
            return runCommand(MaintenanceWindowRunCommandParameters.builder().applyMutation(runCommand).build());
        }

        /**
         * <p>
         * The parameters for an AUTOMATION task type.
         * </p>
         * 
         * @param automation
         *        The parameters for an AUTOMATION task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(MaintenanceWindowAutomationParameters automation);

        /**
         * <p>
         * The parameters for an AUTOMATION task type.
         * </p>
         * This is a convenience that creates an instance of the {@link MaintenanceWindowAutomationParameters.Builder}
         * avoiding the need to create one manually via {@link MaintenanceWindowAutomationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowAutomationParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #automation(MaintenanceWindowAutomationParameters)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link MaintenanceWindowAutomationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(MaintenanceWindowAutomationParameters)
         */
        default Builder automation(Consumer<MaintenanceWindowAutomationParameters.Builder> automation) {
            return automation(MaintenanceWindowAutomationParameters.builder().applyMutation(automation).build());
        }

        /**
         * <p>
         * The parameters for a STEP_FUNCTION task type.
         * </p>
         * 
         * @param stepFunctions
         *        The parameters for a STEP_FUNCTION task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepFunctions(MaintenanceWindowStepFunctionsParameters stepFunctions);

        /**
         * <p>
         * The parameters for a STEP_FUNCTION task type.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link MaintenanceWindowStepFunctionsParameters.Builder} avoiding the need to create one manually via
         * {@link MaintenanceWindowStepFunctionsParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowStepFunctionsParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #stepFunctions(MaintenanceWindowStepFunctionsParameters)}.
         * 
         * @param stepFunctions
         *        a consumer that will call methods on {@link MaintenanceWindowStepFunctionsParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepFunctions(MaintenanceWindowStepFunctionsParameters)
         */
        default Builder stepFunctions(Consumer<MaintenanceWindowStepFunctionsParameters.Builder> stepFunctions) {
            return stepFunctions(MaintenanceWindowStepFunctionsParameters.builder().applyMutation(stepFunctions).build());
        }

        /**
         * <p>
         * The parameters for a LAMBDA task type.
         * </p>
         * 
         * @param lambda
         *        The parameters for a LAMBDA task type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(MaintenanceWindowLambdaParameters lambda);

        /**
         * <p>
         * The parameters for a LAMBDA task type.
         * </p>
         * This is a convenience that creates an instance of the {@link MaintenanceWindowLambdaParameters.Builder}
         * avoiding the need to create one manually via {@link MaintenanceWindowLambdaParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowLambdaParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #lambda(MaintenanceWindowLambdaParameters)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link MaintenanceWindowLambdaParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(MaintenanceWindowLambdaParameters)
         */
        default Builder lambda(Consumer<MaintenanceWindowLambdaParameters.Builder> lambda) {
            return lambda(MaintenanceWindowLambdaParameters.builder().applyMutation(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MaintenanceWindowRunCommandParameters runCommand;

        private MaintenanceWindowAutomationParameters automation;

        private MaintenanceWindowStepFunctionsParameters stepFunctions;

        private MaintenanceWindowLambdaParameters lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskInvocationParameters model) {
            runCommand(model.runCommand);
            automation(model.automation);
            stepFunctions(model.stepFunctions);
            lambda(model.lambda);
        }

        public final MaintenanceWindowRunCommandParameters.Builder getRunCommand() {
            return runCommand != null ? runCommand.toBuilder() : null;
        }

        @Override
        public final Builder runCommand(MaintenanceWindowRunCommandParameters runCommand) {
            this.runCommand = runCommand;
            return this;
        }

        public final void setRunCommand(MaintenanceWindowRunCommandParameters.BuilderImpl runCommand) {
            this.runCommand = runCommand != null ? runCommand.build() : null;
        }

        public final MaintenanceWindowAutomationParameters.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        @Override
        public final Builder automation(MaintenanceWindowAutomationParameters automation) {
            this.automation = automation;
            return this;
        }

        public final void setAutomation(MaintenanceWindowAutomationParameters.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        public final MaintenanceWindowStepFunctionsParameters.Builder getStepFunctions() {
            return stepFunctions != null ? stepFunctions.toBuilder() : null;
        }

        @Override
        public final Builder stepFunctions(MaintenanceWindowStepFunctionsParameters stepFunctions) {
            this.stepFunctions = stepFunctions;
            return this;
        }

        public final void setStepFunctions(MaintenanceWindowStepFunctionsParameters.BuilderImpl stepFunctions) {
            this.stepFunctions = stepFunctions != null ? stepFunctions.build() : null;
        }

        public final MaintenanceWindowLambdaParameters.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(MaintenanceWindowLambdaParameters lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(MaintenanceWindowLambdaParameters.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public MaintenanceWindowTaskInvocationParameters build() {
            return new MaintenanceWindowTaskInvocationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
