/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommandsResponse extends SsmResponse implements
        ToCopyableBuilder<ListCommandsResponse.Builder, ListCommandsResponse> {
    private static final SdkField<List<Command>> COMMANDS_FIELD = SdkField
            .<List<Command>> builder(MarshallingType.LIST)
            .getter(getter(ListCommandsResponse::commands))
            .setter(setter(Builder::commands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Commands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Command> builder(MarshallingType.SDK_POJO)
                                            .constructor(Command::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCommandsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMANDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Command> commands;

    private final String nextToken;

    private ListCommandsResponse(BuilderImpl builder) {
        super(builder);
        this.commands = builder.commands;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * (Optional) The list of commands requested by the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) The list of commands requested by the user.
     */
    public List<Command> commands() {
        return commands;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commands());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandsResponse)) {
            return false;
        }
        ListCommandsResponse other = (ListCommandsResponse) obj;
        return Objects.equals(commands(), other.commands()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCommandsResponse").add("Commands", commands()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Commands":
            return Optional.ofNullable(clazz.cast(commands()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCommandsResponse, T> g) {
        return obj -> g.apply((ListCommandsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCommandsResponse> {
        /**
         * <p>
         * (Optional) The list of commands requested by the user.
         * </p>
         * 
         * @param commands
         *        (Optional) The list of commands requested by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Collection<Command> commands);

        /**
         * <p>
         * (Optional) The list of commands requested by the user.
         * </p>
         * 
         * @param commands
         *        (Optional) The list of commands requested by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Command... commands);

        /**
         * <p>
         * (Optional) The list of commands requested by the user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Command>.Builder} avoiding the need to
         * create one manually via {@link List<Command>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Command>.Builder#build()} is called immediately and its
         * result is passed to {@link #commands(List<Command>)}.
         * 
         * @param commands
         *        a consumer that will call methods on {@link List<Command>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commands(List<Command>)
         */
        Builder commands(Consumer<Command.Builder>... commands);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<Command> commands = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandsResponse model) {
            super(model);
            commands(model.commands);
            nextToken(model.nextToken);
        }

        public final Collection<Command.Builder> getCommands() {
            return commands != null ? commands.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandListCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command... commands) {
            commands(Arrays.asList(commands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Consumer<Command.Builder>... commands) {
            commands(Stream.of(commands).map(c -> Command.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommands(Collection<Command.BuilderImpl> commands) {
            this.commands = CommandListCopier.copyFromBuilder(commands);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCommandsResponse build() {
            return new ListCommandsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
