/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutParameterResponse extends SsmResponse implements
        ToCopyableBuilder<PutParameterResponse.Builder, PutParameterResponse> {
    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(PutParameterResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD));

    private final Long version;

    private PutParameterResponse(BuilderImpl builder) {
        super(builder);
        this.version = builder.version;
    }

    /**
     * <p>
     * The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a new
     * version and assigns this new version a unique ID. You can reference a parameter version ID in API actions or in
     * Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the system
     * returns the latest parameter value when a parameter is called.
     * </p>
     * 
     * @return The new version number of a parameter. If you edit a parameter value, Parameter Store automatically
     *         creates a new version and assigns this new version a unique ID. You can reference a parameter version ID
     *         in API actions or in Systems Manager documents (SSM documents). By default, if you don't specify a
     *         specific version, the system returns the latest parameter value when a parameter is called.
     */
    public Long version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutParameterResponse)) {
            return false;
        }
        PutParameterResponse other = (PutParameterResponse) obj;
        return Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("PutParameterResponse").add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutParameterResponse, T> g) {
        return obj -> g.apply((PutParameterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutParameterResponse> {
        /**
         * <p>
         * The new version number of a parameter. If you edit a parameter value, Parameter Store automatically creates a
         * new version and assigns this new version a unique ID. You can reference a parameter version ID in API actions
         * or in Systems Manager documents (SSM documents). By default, if you don't specify a specific version, the
         * system returns the latest parameter value when a parameter is called.
         * </p>
         * 
         * @param version
         *        The new version number of a parameter. If you edit a parameter value, Parameter Store automatically
         *        creates a new version and assigns this new version a unique ID. You can reference a parameter version
         *        ID in API actions or in Systems Manager documents (SSM documents). By default, if you don't specify a
         *        specific version, the system returns the latest parameter value when a parameter is called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(PutParameterResponse model) {
            super(model);
            version(model.version);
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public PutParameterResponse build() {
            return new PutParameterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
