/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendAutomationSignalRequest extends SsmRequest implements
        ToCopyableBuilder<SendAutomationSignalRequest.Builder, SendAutomationSignalRequest> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendAutomationSignalRequest::automationExecutionId)).setter(setter(Builder::automationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build())
            .build();

    private static final SdkField<String> SIGNAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendAutomationSignalRequest::signalTypeAsString)).setter(setter(Builder::signalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalType").build()).build();

    private static final SdkField<Map<String, List<String>>> PAYLOAD_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(SendAutomationSignalRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD,
            SIGNAL_TYPE_FIELD, PAYLOAD_FIELD));

    private final String automationExecutionId;

    private final String signalType;

    private final Map<String, List<String>> payload;

    private SendAutomationSignalRequest(BuilderImpl builder) {
        super(builder);
        this.automationExecutionId = builder.automationExecutionId;
        this.signalType = builder.signalType;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The unique identifier for an existing Automation execution that you want to send the signal to.
     * </p>
     * 
     * @return The unique identifier for an existing Automation execution that you want to send the signal to.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The type of signal to send to an Automation execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalType} will
     * return {@link SignalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signalTypeAsString}.
     * </p>
     * 
     * @return The type of signal to send to an Automation execution.
     * @see SignalType
     */
    public SignalType signalType() {
        return SignalType.fromValue(signalType);
    }

    /**
     * <p>
     * The type of signal to send to an Automation execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signalType} will
     * return {@link SignalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signalTypeAsString}.
     * </p>
     * 
     * @return The type of signal to send to an Automation execution.
     * @see SignalType
     */
    public String signalTypeAsString() {
        return signalType;
    }

    /**
     * <p>
     * The data sent with the signal. The data schema depends on the type of signal used in the request.
     * </p>
     * <p>
     * For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that you can
     * send with the signal type. For example:
     * </p>
     * <p>
     * <code>Comment="Looks good"</code>
     * </p>
     * <p>
     * For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the Automation step to
     * start or resume as the payload. For example:
     * </p>
     * <p>
     * <code>StepName="step1"</code>
     * </p>
     * <p>
     * For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For example:
     * </p>
     * <p>
     * <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data sent with the signal. The data schema depends on the type of signal used in the request.</p>
     *         <p>
     *         For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that
     *         you can send with the signal type. For example:
     *         </p>
     *         <p>
     *         <code>Comment="Looks good"</code>
     *         </p>
     *         <p>
     *         For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the Automation
     *         step to start or resume as the payload. For example:
     *         </p>
     *         <p>
     *         <code>StepName="step1"</code>
     *         </p>
     *         <p>
     *         For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For
     *         example:
     *         </p>
     *         <p>
     *         <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code>
     */
    public Map<String, List<String>> payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(signalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAutomationSignalRequest)) {
            return false;
        }
        SendAutomationSignalRequest other = (SendAutomationSignalRequest) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId())
                && Objects.equals(signalTypeAsString(), other.signalTypeAsString()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendAutomationSignalRequest").add("AutomationExecutionId", automationExecutionId())
                .add("SignalType", signalTypeAsString()).add("Payload", payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.ofNullable(clazz.cast(automationExecutionId()));
        case "SignalType":
            return Optional.ofNullable(clazz.cast(signalTypeAsString()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendAutomationSignalRequest, T> g) {
        return obj -> g.apply((SendAutomationSignalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendAutomationSignalRequest> {
        /**
         * <p>
         * The unique identifier for an existing Automation execution that you want to send the signal to.
         * </p>
         * 
         * @param automationExecutionId
         *        The unique identifier for an existing Automation execution that you want to send the signal to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The type of signal to send to an Automation execution.
         * </p>
         * 
         * @param signalType
         *        The type of signal to send to an Automation execution.
         * @see SignalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalType
         */
        Builder signalType(String signalType);

        /**
         * <p>
         * The type of signal to send to an Automation execution.
         * </p>
         * 
         * @param signalType
         *        The type of signal to send to an Automation execution.
         * @see SignalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalType
         */
        Builder signalType(SignalType signalType);

        /**
         * <p>
         * The data sent with the signal. The data schema depends on the type of signal used in the request.
         * </p>
         * <p>
         * For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that you
         * can send with the signal type. For example:
         * </p>
         * <p>
         * <code>Comment="Looks good"</code>
         * </p>
         * <p>
         * For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the Automation
         * step to start or resume as the payload. For example:
         * </p>
         * <p>
         * <code>StepName="step1"</code>
         * </p>
         * <p>
         * For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For example:
         * </p>
         * <p>
         * <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code>
         * </p>
         * 
         * @param payload
         *        The data sent with the signal. The data schema depends on the type of signal used in the request.</p>
         *        <p>
         *        For <code>Approve</code> and <code>Reject</code> signal types, the payload is an optional comment that
         *        you can send with the signal type. For example:
         *        </p>
         *        <p>
         *        <code>Comment="Looks good"</code>
         *        </p>
         *        <p>
         *        For <code>StartStep</code> and <code>Resume</code> signal types, you must send the name of the
         *        Automation step to start or resume as the payload. For example:
         *        </p>
         *        <p>
         *        <code>StepName="step1"</code>
         *        </p>
         *        <p>
         *        For the <code>StopStep</code> signal type, you must send the step execution ID as the payload. For
         *        example:
         *        </p>
         *        <p>
         *        <code>StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Map<String, ? extends Collection<String>> payload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String automationExecutionId;

        private String signalType;

        private Map<String, List<String>> payload = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendAutomationSignalRequest model) {
            super(model);
            automationExecutionId(model.automationExecutionId);
            signalType(model.signalType);
            payload(model.payload);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getSignalTypeAsString() {
            return signalType;
        }

        @Override
        public final Builder signalType(String signalType) {
            this.signalType = signalType;
            return this;
        }

        @Override
        public final Builder signalType(SignalType signalType) {
            this.signalType(signalType == null ? null : signalType.toString());
            return this;
        }

        public final void setSignalType(String signalType) {
            this.signalType = signalType;
        }

        public final Map<String, ? extends Collection<String>> getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
            return this;
        }

        public final void setPayload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendAutomationSignalRequest build() {
            return new SendAutomationSignalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
