/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowScheduleResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeMaintenanceWindowScheduleResponse.Builder, DescribeMaintenanceWindowScheduleResponse> {
    private static final SdkField<List<ScheduledWindowExecution>> SCHEDULED_WINDOW_EXECUTIONS_FIELD = SdkField
            .<List<ScheduledWindowExecution>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMaintenanceWindowScheduleResponse::scheduledWindowExecutions))
            .setter(setter(Builder::scheduledWindowExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledWindowExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledWindowExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledWindowExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMaintenanceWindowScheduleResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCHEDULED_WINDOW_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ScheduledWindowExecution> scheduledWindowExecutions;

    private final String nextToken;

    private DescribeMaintenanceWindowScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledWindowExecutions = builder.scheduledWindowExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about maintenance window executions scheduled for the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about maintenance window executions scheduled for the specified time range.
     */
    public List<ScheduledWindowExecution> scheduledWindowExecutions() {
        return scheduledWindowExecutions;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You use this token in the next call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You use this token in the next call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledWindowExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowScheduleResponse)) {
            return false;
        }
        DescribeMaintenanceWindowScheduleResponse other = (DescribeMaintenanceWindowScheduleResponse) obj;
        return Objects.equals(scheduledWindowExecutions(), other.scheduledWindowExecutions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMaintenanceWindowScheduleResponse")
                .add("ScheduledWindowExecutions", scheduledWindowExecutions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledWindowExecutions":
            return Optional.ofNullable(clazz.cast(scheduledWindowExecutions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowScheduleResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceWindowScheduleResponse> {
        /**
         * <p>
         * Information about maintenance window executions scheduled for the specified time range.
         * </p>
         * 
         * @param scheduledWindowExecutions
         *        Information about maintenance window executions scheduled for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledWindowExecutions(Collection<ScheduledWindowExecution> scheduledWindowExecutions);

        /**
         * <p>
         * Information about maintenance window executions scheduled for the specified time range.
         * </p>
         * 
         * @param scheduledWindowExecutions
         *        Information about maintenance window executions scheduled for the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledWindowExecutions(ScheduledWindowExecution... scheduledWindowExecutions);

        /**
         * <p>
         * Information about maintenance window executions scheduled for the specified time range.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledWindowExecution>.Builder} avoiding
         * the need to create one manually via {@link List<ScheduledWindowExecution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledWindowExecution>.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduledWindowExecutions(List<ScheduledWindowExecution>)}.
         * 
         * @param scheduledWindowExecutions
         *        a consumer that will call methods on {@link List<ScheduledWindowExecution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledWindowExecutions(List<ScheduledWindowExecution>)
         */
        Builder scheduledWindowExecutions(Consumer<ScheduledWindowExecution.Builder>... scheduledWindowExecutions);

        /**
         * <p>
         * The token for the next set of items to return. (You use this token in the next call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You use this token in the next call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<ScheduledWindowExecution> scheduledWindowExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowScheduleResponse model) {
            super(model);
            scheduledWindowExecutions(model.scheduledWindowExecutions);
            nextToken(model.nextToken);
        }

        public final Collection<ScheduledWindowExecution.Builder> getScheduledWindowExecutions() {
            return scheduledWindowExecutions != null ? scheduledWindowExecutions.stream()
                    .map(ScheduledWindowExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledWindowExecutions(Collection<ScheduledWindowExecution> scheduledWindowExecutions) {
            this.scheduledWindowExecutions = ScheduledWindowExecutionListCopier.copy(scheduledWindowExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledWindowExecutions(ScheduledWindowExecution... scheduledWindowExecutions) {
            scheduledWindowExecutions(Arrays.asList(scheduledWindowExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledWindowExecutions(Consumer<ScheduledWindowExecution.Builder>... scheduledWindowExecutions) {
            scheduledWindowExecutions(Stream.of(scheduledWindowExecutions)
                    .map(c -> ScheduledWindowExecution.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledWindowExecutions(Collection<ScheduledWindowExecution.BuilderImpl> scheduledWindowExecutions) {
            this.scheduledWindowExecutions = ScheduledWindowExecutionListCopier.copyFromBuilder(scheduledWindowExecutions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowScheduleResponse build() {
            return new DescribeMaintenanceWindowScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
