/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the current state of an individual Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationExecution.Builder, AutomationExecution> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::automationExecutionId)).setter(setter(Builder::automationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build())
            .build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::documentName)).setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::documentVersion)).setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutomationExecution::executionStartTime)).setter(setter(Builder::executionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build())
            .build();

    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutomationExecution::executionEndTime)).setter(setter(Builder::executionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()).build();

    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::automationExecutionStatusAsString))
            .setter(setter(Builder::automationExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build())
            .build();

    private static final SdkField<List<StepExecution>> STEP_EXECUTIONS_FIELD = SdkField
            .<List<StepExecution>> builder(MarshallingType.LIST)
            .getter(getter(AutomationExecution::stepExecutions))
            .setter(setter(Builder::stepExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> STEP_EXECUTIONS_TRUNCATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AutomationExecution::stepExecutionsTruncated)).setter(setter(Builder::stepExecutionsTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutionsTruncated").build())
            .build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(AutomationExecution::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(AutomationExecution::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::failureMessage)).setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PARENT_AUTOMATION_EXECUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::parentAutomationExecutionId))
            .setter(setter(Builder::parentAutomationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentAutomationExecutionId")
                    .build()).build();

    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::executedBy)).setter(setter(Builder::executedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()).build();

    private static final SdkField<String> CURRENT_STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::currentStepName)).setter(setter(Builder::currentStepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStepName").build()).build();

    private static final SdkField<String> CURRENT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::currentAction)).setter(setter(Builder::currentAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAction").build()).build();

    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::targetParameterName)).setter(setter(Builder::targetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build())
            .build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .getter(getter(AutomationExecution::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField
            .<List<Map<String, List<String>>>> builder(MarshallingType.LIST)
            .getter(getter(AutomationExecution::targetMaps))
            .setter(setter(Builder::targetMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<ResolvedTargets> RESOLVED_TARGETS_FIELD = SdkField
            .<ResolvedTargets> builder(MarshallingType.SDK_POJO).getter(getter(AutomationExecution::resolvedTargets))
            .setter(setter(Builder::resolvedTargets)).constructor(ResolvedTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedTargets").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::maxConcurrency)).setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::maxErrors)).setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutomationExecution::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField
            .<List<TargetLocation>> builder(MarshallingType.LIST)
            .getter(getter(AutomationExecution::targetLocations))
            .setter(setter(Builder::targetLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProgressCounters> PROGRESS_COUNTERS_FIELD = SdkField
            .<ProgressCounters> builder(MarshallingType.SDK_POJO).getter(getter(AutomationExecution::progressCounters))
            .setter(setter(Builder::progressCounters)).constructor(ProgressCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressCounters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD,
            DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD,
            AUTOMATION_EXECUTION_STATUS_FIELD, STEP_EXECUTIONS_FIELD, STEP_EXECUTIONS_TRUNCATED_FIELD, PARAMETERS_FIELD,
            OUTPUTS_FIELD, FAILURE_MESSAGE_FIELD, MODE_FIELD, PARENT_AUTOMATION_EXECUTION_ID_FIELD, EXECUTED_BY_FIELD,
            CURRENT_STEP_NAME_FIELD, CURRENT_ACTION_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD,
            RESOLVED_TARGETS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_FIELD, TARGET_LOCATIONS_FIELD,
            PROGRESS_COUNTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String automationExecutionId;

    private final String documentName;

    private final String documentVersion;

    private final Instant executionStartTime;

    private final Instant executionEndTime;

    private final String automationExecutionStatus;

    private final List<StepExecution> stepExecutions;

    private final Boolean stepExecutionsTruncated;

    private final Map<String, List<String>> parameters;

    private final Map<String, List<String>> outputs;

    private final String failureMessage;

    private final String mode;

    private final String parentAutomationExecutionId;

    private final String executedBy;

    private final String currentStepName;

    private final String currentAction;

    private final String targetParameterName;

    private final List<Target> targets;

    private final List<Map<String, List<String>>> targetMaps;

    private final ResolvedTargets resolvedTargets;

    private final String maxConcurrency;

    private final String maxErrors;

    private final String target;

    private final List<TargetLocation> targetLocations;

    private final ProgressCounters progressCounters;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.stepExecutionsTruncated = builder.stepExecutionsTruncated;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
        this.mode = builder.mode;
        this.parentAutomationExecutionId = builder.parentAutomationExecutionId;
        this.executedBy = builder.executedBy;
        this.currentStepName = builder.currentStepName;
        this.currentAction = builder.currentAction;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.resolvedTargets = builder.resolvedTargets;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.target = builder.target;
        this.targetLocations = builder.targetLocations;
        this.progressCounters = builder.progressCounters;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The name of the Automation document used during the execution.
     * </p>
     * 
     * @return The name of the Automation document used during the execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the document to use during execution.
     * </p>
     * 
     * @return The version of the document to use during execution.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The time the execution started.
     * </p>
     * 
     * @return The time the execution started.
     */
    public Instant executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the execution finished.
     * </p>
     * 
     * @return The time the execution finished.
     */
    public Instant executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The execution status of the Automation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusAsString}.
     * </p>
     * 
     * @return The execution status of the Automation.
     * @see AutomationExecutionStatus
     */
    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(automationExecutionStatus);
    }

    /**
     * <p>
     * The execution status of the Automation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusAsString}.
     * </p>
     * 
     * @return The execution status of the Automation.
     * @see AutomationExecutionStatus
     */
    public String automationExecutionStatusAsString() {
        return automationExecutionStatus;
    }

    /**
     * <p>
     * A list of details about the current state of all steps that comprise an execution. An Automation document
     * contains a list of steps that are run in order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of details about the current state of all steps that comprise an execution. An Automation document
     *         contains a list of steps that are run in order.
     */
    public List<StepExecution> stepExecutions() {
        return stepExecutions;
    }

    /**
     * <p>
     * A boolean value that indicates if the response contains the full list of the Automation step executions. If true,
     * use the DescribeAutomationStepExecutions API action to get the full list of step executions.
     * </p>
     * 
     * @return A boolean value that indicates if the response contains the full list of the Automation step executions.
     *         If true, use the DescribeAutomationStepExecutions API action to get the full list of step executions.
     */
    public Boolean stepExecutionsTruncated() {
        return stepExecutionsTruncated;
    }

    /**
     * <p>
     * The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the automation document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of execution outputs as defined in the automation document.
     */
    public Map<String, List<String>> outputs() {
        return outputs;
    }

    /**
     * <p>
     * A message describing why an execution has failed, if the status is set to Failed.
     * </p>
     * 
     * @return A message describing why an execution has failed, if the status is set to Failed.
     */
    public String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The automation execution mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The automation execution mode.
     * @see ExecutionMode
     */
    public ExecutionMode mode() {
        return ExecutionMode.fromValue(mode);
    }

    /**
     * <p>
     * The automation execution mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The automation execution mode.
     * @see ExecutionMode
     */
    public String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The AutomationExecutionId of the parent automation.
     * </p>
     * 
     * @return The AutomationExecutionId of the parent automation.
     */
    public String parentAutomationExecutionId() {
        return parentAutomationExecutionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who ran the automation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who ran the automation.
     */
    public String executedBy() {
        return executedBy;
    }

    /**
     * <p>
     * The name of the step that is currently running.
     * </p>
     * 
     * @return The name of the step that is currently running.
     */
    public String currentStepName() {
        return currentStepName;
    }

    /**
     * <p>
     * The action of the step that is currently running.
     * </p>
     * 
     * @return The action of the step that is currently running.
     */
    public String currentAction() {
        return currentAction;
    }

    /**
     * <p>
     * The parameter name.
     * </p>
     * 
     * @return The parameter name.
     */
    public String targetParameterName() {
        return targetParameterName;
    }

    /**
     * <p>
     * The specified targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The specified targets.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The specified key-value mapping of document parameters to target resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The specified key-value mapping of document parameters to target resources.
     */
    public List<Map<String, List<String>>> targetMaps() {
        return targetMaps;
    }

    /**
     * <p>
     * A list of resolved targets in the rate control execution.
     * </p>
     * 
     * @return A list of resolved targets in the rate control execution.
     */
    public ResolvedTargets resolvedTargets() {
        return resolvedTargets;
    }

    /**
     * <p>
     * The MaxConcurrency value specified by the user when the execution started.
     * </p>
     * 
     * @return The MaxConcurrency value specified by the user when the execution started.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The MaxErrors value specified by the user when the execution started.
     * </p>
     * 
     * @return The MaxErrors value specified by the user when the execution started.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The target of the execution.
     * </p>
     * 
     * @return The target of the execution.
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
     */
    public List<TargetLocation> targetLocations() {
        return targetLocations;
    }

    /**
     * <p>
     * An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and multi-account
     * Automation execution.
     * </p>
     * 
     * @return An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and multi-account
     *         Automation execution.
     */
    public ProgressCounters progressCounters() {
        return progressCounters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionsTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parentAutomationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(currentStepName());
        hashCode = 31 * hashCode + Objects.hashCode(currentAction());
        hashCode = 31 * hashCode + Objects.hashCode(targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(targetMaps());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocations());
        hashCode = 31 * hashCode + Objects.hashCode(progressCounters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId())
                && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(executionStartTime(), other.executionStartTime())
                && Objects.equals(executionEndTime(), other.executionEndTime())
                && Objects.equals(automationExecutionStatusAsString(), other.automationExecutionStatusAsString())
                && Objects.equals(stepExecutions(), other.stepExecutions())
                && Objects.equals(stepExecutionsTruncated(), other.stepExecutionsTruncated())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(outputs(), other.outputs())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(parentAutomationExecutionId(), other.parentAutomationExecutionId())
                && Objects.equals(executedBy(), other.executedBy()) && Objects.equals(currentStepName(), other.currentStepName())
                && Objects.equals(currentAction(), other.currentAction())
                && Objects.equals(targetParameterName(), other.targetParameterName())
                && Objects.equals(targets(), other.targets()) && Objects.equals(targetMaps(), other.targetMaps())
                && Objects.equals(resolvedTargets(), other.resolvedTargets())
                && Objects.equals(maxConcurrency(), other.maxConcurrency()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(target(), other.target()) && Objects.equals(targetLocations(), other.targetLocations())
                && Objects.equals(progressCounters(), other.progressCounters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutomationExecution").add("AutomationExecutionId", automationExecutionId())
                .add("DocumentName", documentName()).add("DocumentVersion", documentVersion())
                .add("ExecutionStartTime", executionStartTime()).add("ExecutionEndTime", executionEndTime())
                .add("AutomationExecutionStatus", automationExecutionStatusAsString()).add("StepExecutions", stepExecutions())
                .add("StepExecutionsTruncated", stepExecutionsTruncated()).add("Parameters", parameters())
                .add("Outputs", outputs()).add("FailureMessage", failureMessage()).add("Mode", modeAsString())
                .add("ParentAutomationExecutionId", parentAutomationExecutionId()).add("ExecutedBy", executedBy())
                .add("CurrentStepName", currentStepName()).add("CurrentAction", currentAction())
                .add("TargetParameterName", targetParameterName()).add("Targets", targets()).add("TargetMaps", targetMaps())
                .add("ResolvedTargets", resolvedTargets()).add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors())
                .add("Target", target()).add("TargetLocations", targetLocations()).add("ProgressCounters", progressCounters())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.ofNullable(clazz.cast(automationExecutionId()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "ExecutionStartTime":
            return Optional.ofNullable(clazz.cast(executionStartTime()));
        case "ExecutionEndTime":
            return Optional.ofNullable(clazz.cast(executionEndTime()));
        case "AutomationExecutionStatus":
            return Optional.ofNullable(clazz.cast(automationExecutionStatusAsString()));
        case "StepExecutions":
            return Optional.ofNullable(clazz.cast(stepExecutions()));
        case "StepExecutionsTruncated":
            return Optional.ofNullable(clazz.cast(stepExecutionsTruncated()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "ParentAutomationExecutionId":
            return Optional.ofNullable(clazz.cast(parentAutomationExecutionId()));
        case "ExecutedBy":
            return Optional.ofNullable(clazz.cast(executedBy()));
        case "CurrentStepName":
            return Optional.ofNullable(clazz.cast(currentStepName()));
        case "CurrentAction":
            return Optional.ofNullable(clazz.cast(currentAction()));
        case "TargetParameterName":
            return Optional.ofNullable(clazz.cast(targetParameterName()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TargetMaps":
            return Optional.ofNullable(clazz.cast(targetMaps()));
        case "ResolvedTargets":
            return Optional.ofNullable(clazz.cast(resolvedTargets()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "TargetLocations":
            return Optional.ofNullable(clazz.cast(targetLocations()));
        case "ProgressCounters":
            return Optional.ofNullable(clazz.cast(progressCounters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecution, T> g) {
        return obj -> g.apply((AutomationExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationExecution> {
        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The name of the Automation document used during the execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation document used during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the document to use during execution.
         * </p>
         * 
         * @param documentVersion
         *        The version of the document to use during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The time the execution started.
         * </p>
         * 
         * @param executionStartTime
         *        The time the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Instant executionStartTime);

        /**
         * <p>
         * The time the execution finished.
         * </p>
         * 
         * @param executionEndTime
         *        The time the execution finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Instant executionEndTime);

        /**
         * <p>
         * The execution status of the Automation.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The execution status of the Automation.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(String automationExecutionStatus);

        /**
         * <p>
         * The execution status of the Automation.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The execution status of the Automation.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus);

        /**
         * <p>
         * A list of details about the current state of all steps that comprise an execution. An Automation document
         * contains a list of steps that are run in order.
         * </p>
         * 
         * @param stepExecutions
         *        A list of details about the current state of all steps that comprise an execution. An Automation
         *        document contains a list of steps that are run in order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutions(Collection<StepExecution> stepExecutions);

        /**
         * <p>
         * A list of details about the current state of all steps that comprise an execution. An Automation document
         * contains a list of steps that are run in order.
         * </p>
         * 
         * @param stepExecutions
         *        A list of details about the current state of all steps that comprise an execution. An Automation
         *        document contains a list of steps that are run in order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutions(StepExecution... stepExecutions);

        /**
         * <p>
         * A list of details about the current state of all steps that comprise an execution. An Automation document
         * contains a list of steps that are run in order.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StepExecution>.Builder} avoiding the need
         * to create one manually via {@link List<StepExecution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StepExecution>.Builder#build()} is called immediately and
         * its result is passed to {@link #stepExecutions(List<StepExecution>)}.
         * 
         * @param stepExecutions
         *        a consumer that will call methods on {@link List<StepExecution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepExecutions(List<StepExecution>)
         */
        Builder stepExecutions(Consumer<StepExecution.Builder>... stepExecutions);

        /**
         * <p>
         * A boolean value that indicates if the response contains the full list of the Automation step executions. If
         * true, use the DescribeAutomationStepExecutions API action to get the full list of step executions.
         * </p>
         * 
         * @param stepExecutionsTruncated
         *        A boolean value that indicates if the response contains the full list of the Automation step
         *        executions. If true, use the DescribeAutomationStepExecutions API action to get the full list of step
         *        executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionsTruncated(Boolean stepExecutionsTruncated);

        /**
         * <p>
         * The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
         * </p>
         * 
         * @param parameters
         *        The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The list of execution outputs as defined in the automation document.
         * </p>
         * 
         * @param outputs
         *        The list of execution outputs as defined in the automation document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);

        /**
         * <p>
         * A message describing why an execution has failed, if the status is set to Failed.
         * </p>
         * 
         * @param failureMessage
         *        A message describing why an execution has failed, if the status is set to Failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The automation execution mode.
         * </p>
         * 
         * @param mode
         *        The automation execution mode.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The automation execution mode.
         * </p>
         * 
         * @param mode
         *        The automation execution mode.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(ExecutionMode mode);

        /**
         * <p>
         * The AutomationExecutionId of the parent automation.
         * </p>
         * 
         * @param parentAutomationExecutionId
         *        The AutomationExecutionId of the parent automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentAutomationExecutionId(String parentAutomationExecutionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who ran the automation.
         * </p>
         * 
         * @param executedBy
         *        The Amazon Resource Name (ARN) of the user who ran the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedBy(String executedBy);

        /**
         * <p>
         * The name of the step that is currently running.
         * </p>
         * 
         * @param currentStepName
         *        The name of the step that is currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentStepName(String currentStepName);

        /**
         * <p>
         * The action of the step that is currently running.
         * </p>
         * 
         * @param currentAction
         *        The action of the step that is currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAction(String currentAction);

        /**
         * <p>
         * The parameter name.
         * </p>
         * 
         * @param targetParameterName
         *        The parameter name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameterName(String targetParameterName);

        /**
         * <p>
         * The specified targets.
         * </p>
         * 
         * @param targets
         *        The specified targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The specified targets.
         * </p>
         * 
         * @param targets
         *        The specified targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The specified targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The specified key-value mapping of document parameters to target resources.
         * </p>
         * 
         * @param targetMaps
         *        The specified key-value mapping of document parameters to target resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps);

        /**
         * <p>
         * The specified key-value mapping of document parameters to target resources.
         * </p>
         * 
         * @param targetMaps
         *        The specified key-value mapping of document parameters to target resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps);

        /**
         * <p>
         * A list of resolved targets in the rate control execution.
         * </p>
         * 
         * @param resolvedTargets
         *        A list of resolved targets in the rate control execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedTargets(ResolvedTargets resolvedTargets);

        /**
         * <p>
         * A list of resolved targets in the rate control execution.
         * </p>
         * This is a convenience that creates an instance of the {@link ResolvedTargets.Builder} avoiding the need to
         * create one manually via {@link ResolvedTargets#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolvedTargets.Builder#build()} is called immediately and its
         * result is passed to {@link #resolvedTargets(ResolvedTargets)}.
         * 
         * @param resolvedTargets
         *        a consumer that will call methods on {@link ResolvedTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvedTargets(ResolvedTargets)
         */
        default Builder resolvedTargets(Consumer<ResolvedTargets.Builder> resolvedTargets) {
            return resolvedTargets(ResolvedTargets.builder().applyMutation(resolvedTargets).build());
        }

        /**
         * <p>
         * The MaxConcurrency value specified by the user when the execution started.
         * </p>
         * 
         * @param maxConcurrency
         *        The MaxConcurrency value specified by the user when the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The MaxErrors value specified by the user when the execution started.
         * </p>
         * 
         * @param maxErrors
         *        The MaxErrors value specified by the user when the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The target of the execution.
         * </p>
         * 
         * @param target
         *        The target of the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
         * </p>
         * 
         * @param targetLocations
         *        The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(Collection<TargetLocation> targetLocations);

        /**
         * <p>
         * The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
         * </p>
         * 
         * @param targetLocations
         *        The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(TargetLocation... targetLocations);

        /**
         * <p>
         * The combination of AWS Regions and/or AWS accounts where you want to run the Automation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetLocation>.Builder} avoiding the need
         * to create one manually via {@link List<TargetLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetLocation>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetLocations(List<TargetLocation>)}.
         * 
         * @param targetLocations
         *        a consumer that will call methods on {@link List<TargetLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocations(List<TargetLocation>)
         */
        Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations);

        /**
         * <p>
         * An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and multi-account
         * Automation execution.
         * </p>
         * 
         * @param progressCounters
         *        An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and
         *        multi-account Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressCounters(ProgressCounters progressCounters);

        /**
         * <p>
         * An aggregate of step execution statuses displayed in the AWS Console for a multi-Region and multi-account
         * Automation execution.
         * </p>
         * This is a convenience that creates an instance of the {@link ProgressCounters.Builder} avoiding the need to
         * create one manually via {@link ProgressCounters#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProgressCounters.Builder#build()} is called immediately and its
         * result is passed to {@link #progressCounters(ProgressCounters)}.
         * 
         * @param progressCounters
         *        a consumer that will call methods on {@link ProgressCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressCounters(ProgressCounters)
         */
        default Builder progressCounters(Consumer<ProgressCounters.Builder> progressCounters) {
            return progressCounters(ProgressCounters.builder().applyMutation(progressCounters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private String documentName;

        private String documentVersion;

        private Instant executionStartTime;

        private Instant executionEndTime;

        private String automationExecutionStatus;

        private List<StepExecution> stepExecutions = DefaultSdkAutoConstructList.getInstance();

        private Boolean stepExecutionsTruncated;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();

        private String failureMessage;

        private String mode;

        private String parentAutomationExecutionId;

        private String executedBy;

        private String currentStepName;

        private String currentAction;

        private String targetParameterName;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();

        private ResolvedTargets resolvedTargets;

        private String maxConcurrency;

        private String maxErrors;

        private String target;

        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private ProgressCounters progressCounters;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            automationExecutionId(model.automationExecutionId);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            executionStartTime(model.executionStartTime);
            executionEndTime(model.executionEndTime);
            automationExecutionStatus(model.automationExecutionStatus);
            stepExecutions(model.stepExecutions);
            stepExecutionsTruncated(model.stepExecutionsTruncated);
            parameters(model.parameters);
            outputs(model.outputs);
            failureMessage(model.failureMessage);
            mode(model.mode);
            parentAutomationExecutionId(model.parentAutomationExecutionId);
            executedBy(model.executedBy);
            currentStepName(model.currentStepName);
            currentAction(model.currentAction);
            targetParameterName(model.targetParameterName);
            targets(model.targets);
            targetMaps(model.targetMaps);
            resolvedTargets(model.resolvedTargets);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            target(model.target);
            targetLocations(model.targetLocations);
            progressCounters(model.progressCounters);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getExecutionStartTime() {
            return executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getAutomationExecutionStatusAsString() {
            return automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus == null ? null : automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Collection<StepExecution.Builder> getStepExecutions() {
            return stepExecutions != null ? stepExecutions.stream().map(StepExecution::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution... stepExecutions) {
            stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(Consumer<StepExecution.Builder>... stepExecutions) {
            stepExecutions(Stream.of(stepExecutions).map(c -> StepExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        public final Boolean getStepExecutionsTruncated() {
            return stepExecutionsTruncated;
        }

        @Override
        public final Builder stepExecutionsTruncated(Boolean stepExecutionsTruncated) {
            this.stepExecutionsTruncated = stepExecutionsTruncated;
            return this;
        }

        public final void setStepExecutionsTruncated(Boolean stepExecutionsTruncated) {
            this.stepExecutionsTruncated = stepExecutionsTruncated;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final String getModeAsString() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getParentAutomationExecutionId() {
            return parentAutomationExecutionId;
        }

        @Override
        public final Builder parentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
            return this;
        }

        public final void setParentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
        }

        public final String getExecutedBy() {
            return executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getCurrentStepName() {
            return currentStepName;
        }

        @Override
        public final Builder currentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
            return this;
        }

        public final void setCurrentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
        }

        public final String getCurrentAction() {
            return currentAction;
        }

        @Override
        public final Builder currentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public final void setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
        }

        public final String getTargetParameterName() {
            return targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            return targetMaps;
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps) {
            targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        public final ResolvedTargets.Builder getResolvedTargets() {
            return resolvedTargets != null ? resolvedTargets.toBuilder() : null;
        }

        @Override
        public final Builder resolvedTargets(ResolvedTargets resolvedTargets) {
            this.resolvedTargets = resolvedTargets;
            return this;
        }

        public final void setResolvedTargets(ResolvedTargets.BuilderImpl resolvedTargets) {
            this.resolvedTargets = resolvedTargets != null ? resolvedTargets.build() : null;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Collection<TargetLocation.Builder> getTargetLocations() {
            return targetLocations != null ? targetLocations.stream().map(TargetLocation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation... targetLocations) {
            targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations) {
            targetLocations(Stream.of(targetLocations).map(c -> TargetLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        public final ProgressCounters.Builder getProgressCounters() {
            return progressCounters != null ? progressCounters.toBuilder() : null;
        }

        @Override
        public final Builder progressCounters(ProgressCounters progressCounters) {
            this.progressCounters = progressCounters;
            return this;
        }

        public final void setProgressCounters(ProgressCounters.BuilderImpl progressCounters) {
            this.progressCounters = progressCounters != null ? progressCounters.build() : null;
        }

        @Override
        public AutomationExecution build() {
            return new AutomationExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
