/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCalendarStateRequest extends SsmRequest implements
        ToCopyableBuilder<GetCalendarStateRequest.Builder, GetCalendarStateRequest> {
    private static final SdkField<List<String>> CALENDAR_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetCalendarStateRequest::calendarNames))
            .setter(setter(Builder::calendarNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCalendarStateRequest::atTime)).setter(setter(Builder::atTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALENDAR_NAMES_FIELD,
            AT_TIME_FIELD));

    private final List<String> calendarNames;

    private final String atTime;

    private GetCalendarStateRequest(BuilderImpl builder) {
        super(builder);
        this.calendarNames = builder.calendarNames;
        this.atTime = builder.atTime;
    }

    /**
     * <p>
     * The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar entries
     * for which you want to get the state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar
     *         entries for which you want to get the state.
     */
    public List<String> calendarNames() {
        return calendarNames;
    }

    /**
     * <p>
     * (Optional) The specific time for which you want to get calendar state information, in <a
     * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you do not add <code>AtTime</code>, the
     * current time is assumed.
     * </p>
     * 
     * @return (Optional) The specific time for which you want to get calendar state information, in <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you do not add <code>AtTime</code>,
     *         the current time is assumed.
     */
    public String atTime() {
        return atTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(calendarNames());
        hashCode = 31 * hashCode + Objects.hashCode(atTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalendarStateRequest)) {
            return false;
        }
        GetCalendarStateRequest other = (GetCalendarStateRequest) obj;
        return Objects.equals(calendarNames(), other.calendarNames()) && Objects.equals(atTime(), other.atTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCalendarStateRequest").add("CalendarNames", calendarNames()).add("AtTime", atTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalendarNames":
            return Optional.ofNullable(clazz.cast(calendarNames()));
        case "AtTime":
            return Optional.ofNullable(clazz.cast(atTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCalendarStateRequest, T> g) {
        return obj -> g.apply((GetCalendarStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCalendarStateRequest> {
        /**
         * <p>
         * The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar
         * entries for which you want to get the state.
         * </p>
         * 
         * @param calendarNames
         *        The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar
         *        entries for which you want to get the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarNames(Collection<String> calendarNames);

        /**
         * <p>
         * The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar
         * entries for which you want to get the state.
         * </p>
         * 
         * @param calendarNames
         *        The names or Amazon Resource Names (ARNs) of the Systems Manager documents that represent the calendar
         *        entries for which you want to get the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarNames(String... calendarNames);

        /**
         * <p>
         * (Optional) The specific time for which you want to get calendar state information, in <a
         * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you do not add <code>AtTime</code>, the
         * current time is assumed.
         * </p>
         * 
         * @param atTime
         *        (Optional) The specific time for which you want to get calendar state information, in <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601</a> format. If you do not add
         *        <code>AtTime</code>, the current time is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atTime(String atTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<String> calendarNames = DefaultSdkAutoConstructList.getInstance();

        private String atTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalendarStateRequest model) {
            super(model);
            calendarNames(model.calendarNames);
            atTime(model.atTime);
        }

        public final Collection<String> getCalendarNames() {
            return calendarNames;
        }

        @Override
        public final Builder calendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calendarNames(String... calendarNames) {
            calendarNames(Arrays.asList(calendarNames));
            return this;
        }

        public final void setCalendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
        }

        public final String getAtTime() {
            return atTime;
        }

        @Override
        public final Builder atTime(String atTime) {
            this.atTime = atTime;
            return this;
        }

        public final void setAtTime(String atTime) {
            this.atTime = atTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCalendarStateRequest build() {
            return new GetCalendarStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
