/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifying information about a document attachment, including the file name and a key-value pair that identifies the
 * location of an attachment to a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentsSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentsSource.Builder, AttachmentsSource> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentsSource::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AttachmentsSource::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachmentsSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD,
            NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private final String name;

    private AttachmentsSource(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.name = builder.name;
    }

    /**
     * <p>
     * The key of a key-value pair that identifies the location of an attachment to a document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AttachmentsSourceKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The key of a key-value pair that identifies the location of an attachment to a document.
     * @see AttachmentsSourceKey
     */
    public AttachmentsSourceKey key() {
        return AttachmentsSourceKey.fromValue(key);
    }

    /**
     * <p>
     * The key of a key-value pair that identifies the location of an attachment to a document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AttachmentsSourceKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The key of a key-value pair that identifies the location of an attachment to a document.
     * @see AttachmentsSourceKey
     */
    public String keyAsString() {
        return key;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value of a key-value pair that identifies the location of an attachment to a document. The format is the URL
     * of the location of a document attachment, such as the URL of an Amazon S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of a key-value pair that identifies the location of an attachment to a document. The format is
     *         the URL of the location of a document attachment, such as the URL of an Amazon S3 bucket.
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The name of the document attachment file.
     * </p>
     * 
     * @return The name of the document attachment file.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentsSource)) {
            return false;
        }
        AttachmentsSource other = (AttachmentsSource) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(values(), other.values())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachmentsSource").add("Key", keyAsString()).add("Values", values()).add("Name", name())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentsSource, T> g) {
        return obj -> g.apply((AttachmentsSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentsSource> {
        /**
         * <p>
         * The key of a key-value pair that identifies the location of an attachment to a document.
         * </p>
         * 
         * @param key
         *        The key of a key-value pair that identifies the location of an attachment to a document.
         * @see AttachmentsSourceKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentsSourceKey
         */
        Builder key(String key);

        /**
         * <p>
         * The key of a key-value pair that identifies the location of an attachment to a document.
         * </p>
         * 
         * @param key
         *        The key of a key-value pair that identifies the location of an attachment to a document.
         * @see AttachmentsSourceKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentsSourceKey
         */
        Builder key(AttachmentsSourceKey key);

        /**
         * <p>
         * The value of a key-value pair that identifies the location of an attachment to a document. The format is the
         * URL of the location of a document attachment, such as the URL of an Amazon S3 bucket.
         * </p>
         * 
         * @param values
         *        The value of a key-value pair that identifies the location of an attachment to a document. The format
         *        is the URL of the location of a document attachment, such as the URL of an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value of a key-value pair that identifies the location of an attachment to a document. The format is the
         * URL of the location of a document attachment, such as the URL of an Amazon S3 bucket.
         * </p>
         * 
         * @param values
         *        The value of a key-value pair that identifies the location of an attachment to a document. The format
         *        is the URL of the location of a document attachment, such as the URL of an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The name of the document attachment file.
         * </p>
         * 
         * @param name
         *        The name of the document attachment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentsSource model) {
            key(model.key);
            values(model.values);
            name(model.name);
        }

        public final String getKeyAsString() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(AttachmentsSourceKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = AttachmentsSourceValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = AttachmentsSourceValuesCopier.copy(values);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public AttachmentsSource build() {
            return new AttachmentsSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
