/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutomationStepExecutionsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeAutomationStepExecutionsResponse.Builder, DescribeAutomationStepExecutionsResponse> {
    private static final SdkField<List<StepExecution>> STEP_EXECUTIONS_FIELD = SdkField
            .<List<StepExecution>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAutomationStepExecutionsResponse::stepExecutions))
            .setter(setter(Builder::stepExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAutomationStepExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StepExecution> stepExecutions;

    private final String nextToken;

    private DescribeAutomationStepExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.stepExecutions = builder.stepExecutions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the StepExecutions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStepExecutions() {
        return stepExecutions != null && !(stepExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of details about the current state of all steps that make up an execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepExecutions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of details about the current state of all steps that make up an execution.
     */
    public List<StepExecution> stepExecutions() {
        return stepExecutions;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutomationStepExecutionsResponse)) {
            return false;
        }
        DescribeAutomationStepExecutionsResponse other = (DescribeAutomationStepExecutionsResponse) obj;
        return Objects.equals(stepExecutions(), other.stepExecutions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAutomationStepExecutionsResponse").add("StepExecutions", stepExecutions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepExecutions":
            return Optional.ofNullable(clazz.cast(stepExecutions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutomationStepExecutionsResponse, T> g) {
        return obj -> g.apply((DescribeAutomationStepExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAutomationStepExecutionsResponse> {
        /**
         * <p>
         * A list of details about the current state of all steps that make up an execution.
         * </p>
         * 
         * @param stepExecutions
         *        A list of details about the current state of all steps that make up an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutions(Collection<StepExecution> stepExecutions);

        /**
         * <p>
         * A list of details about the current state of all steps that make up an execution.
         * </p>
         * 
         * @param stepExecutions
         *        A list of details about the current state of all steps that make up an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutions(StepExecution... stepExecutions);

        /**
         * <p>
         * A list of details about the current state of all steps that make up an execution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<StepExecution>.Builder} avoiding the need
         * to create one manually via {@link List<StepExecution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StepExecution>.Builder#build()} is called immediately and
         * its result is passed to {@link #stepExecutions(List<StepExecution>)}.
         * 
         * @param stepExecutions
         *        a consumer that will call methods on {@link List<StepExecution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepExecutions(List<StepExecution>)
         */
        Builder stepExecutions(Consumer<StepExecution.Builder>... stepExecutions);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<StepExecution> stepExecutions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutomationStepExecutionsResponse model) {
            super(model);
            stepExecutions(model.stepExecutions);
            nextToken(model.nextToken);
        }

        public final Collection<StepExecution.Builder> getStepExecutions() {
            return stepExecutions != null ? stepExecutions.stream().map(StepExecution::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution... stepExecutions) {
            stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(Consumer<StepExecution.Builder>... stepExecutions) {
            stepExecutions(Stream.of(stepExecutions).map(c -> StepExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutomationStepExecutionsResponse build() {
            return new DescribeAutomationStepExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
