/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePatchGroupStateResponse extends SsmResponse implements
        ToCopyableBuilder<DescribePatchGroupStateResponse.Builder, DescribePatchGroupStateResponse> {
    private static final SdkField<Integer> INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instances)).setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithInstalledPatches))
            .setter(setter(Builder::instancesWithInstalledPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledPatches")
                    .build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithInstalledOtherPatches))
            .setter(setter(Builder::instancesWithInstalledOtherPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledOtherPatches")
                    .build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_PENDING_REBOOT_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithInstalledPendingRebootPatches))
            .setter(setter(Builder::instancesWithInstalledPendingRebootPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstancesWithInstalledPendingRebootPatches").build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithInstalledRejectedPatches))
            .setter(setter(Builder::instancesWithInstalledRejectedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstancesWithInstalledRejectedPatches").build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_MISSING_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithMissingPatches))
            .setter(setter(Builder::instancesWithMissingPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithMissingPatches")
                    .build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_FAILED_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithFailedPatches))
            .setter(setter(Builder::instancesWithFailedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithFailedPatches").build())
            .build();

    private static final SdkField<Integer> INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithNotApplicablePatches))
            .setter(setter(Builder::instancesWithNotApplicablePatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithNotApplicablePatches")
                    .build()).build();

    private static final SdkField<Integer> INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribePatchGroupStateResponse::instancesWithUnreportedNotApplicablePatches))
            .setter(setter(Builder::instancesWithUnreportedNotApplicablePatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstancesWithUnreportedNotApplicablePatches").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD,
            INSTANCES_WITH_INSTALLED_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD,
            INSTANCES_WITH_INSTALLED_PENDING_REBOOT_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD,
            INSTANCES_WITH_MISSING_PATCHES_FIELD, INSTANCES_WITH_FAILED_PATCHES_FIELD,
            INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD, INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD));

    private final Integer instances;

    private final Integer instancesWithInstalledPatches;

    private final Integer instancesWithInstalledOtherPatches;

    private final Integer instancesWithInstalledPendingRebootPatches;

    private final Integer instancesWithInstalledRejectedPatches;

    private final Integer instancesWithMissingPatches;

    private final Integer instancesWithFailedPatches;

    private final Integer instancesWithNotApplicablePatches;

    private final Integer instancesWithUnreportedNotApplicablePatches;

    private DescribePatchGroupStateResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.instancesWithInstalledPatches = builder.instancesWithInstalledPatches;
        this.instancesWithInstalledOtherPatches = builder.instancesWithInstalledOtherPatches;
        this.instancesWithInstalledPendingRebootPatches = builder.instancesWithInstalledPendingRebootPatches;
        this.instancesWithInstalledRejectedPatches = builder.instancesWithInstalledRejectedPatches;
        this.instancesWithMissingPatches = builder.instancesWithMissingPatches;
        this.instancesWithFailedPatches = builder.instancesWithFailedPatches;
        this.instancesWithNotApplicablePatches = builder.instancesWithNotApplicablePatches;
        this.instancesWithUnreportedNotApplicablePatches = builder.instancesWithUnreportedNotApplicablePatches;
    }

    /**
     * <p>
     * The number of instances in the patch group.
     * </p>
     * 
     * @return The number of instances in the patch group.
     */
    public Integer instances() {
        return instances;
    }

    /**
     * <p>
     * The number of instances with installed patches.
     * </p>
     * 
     * @return The number of instances with installed patches.
     */
    public Integer instancesWithInstalledPatches() {
        return instancesWithInstalledPatches;
    }

    /**
     * <p>
     * The number of instances with patches installed that aren't defined in the patch baseline.
     * </p>
     * 
     * @return The number of instances with patches installed that aren't defined in the patch baseline.
     */
    public Integer instancesWithInstalledOtherPatches() {
        return instancesWithInstalledOtherPatches;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public Integer instancesWithInstalledPendingRebootPatches() {
        return instancesWithInstalledPendingRebootPatches;
    }

    /**
     * <p>
     * The number of instances with patches installed that are specified in a RejectedPatches list. Patches with a
     * status of <i>INSTALLED_REJECTED</i> were typically installed before they were added to a RejectedPatches list.
     * </p>
     * <note>
     * <p>
     * If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction, the value of
     * InstancesWithInstalledRejectedPatches will always be 0 (zero).
     * </p>
     * </note>
     * 
     * @return The number of instances with patches installed that are specified in a RejectedPatches list. Patches with
     *         a status of <i>INSTALLED_REJECTED</i> were typically installed before they were added to a
     *         RejectedPatches list.</p> <note>
     *         <p>
     *         If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction, the value of
     *         InstancesWithInstalledRejectedPatches will always be 0 (zero).
     *         </p>
     */
    public Integer instancesWithInstalledRejectedPatches() {
        return instancesWithInstalledRejectedPatches;
    }

    /**
     * <p>
     * The number of instances with missing patches from the patch baseline.
     * </p>
     * 
     * @return The number of instances with missing patches from the patch baseline.
     */
    public Integer instancesWithMissingPatches() {
        return instancesWithMissingPatches;
    }

    /**
     * <p>
     * The number of instances with patches from the patch baseline that failed to install.
     * </p>
     * 
     * @return The number of instances with patches from the patch baseline that failed to install.
     */
    public Integer instancesWithFailedPatches() {
        return instancesWithFailedPatches;
    }

    /**
     * <p>
     * The number of instances with patches that aren't applicable.
     * </p>
     * 
     * @return The number of instances with patches that aren't applicable.
     */
    public Integer instancesWithNotApplicablePatches() {
        return instancesWithNotApplicablePatches;
    }

    /**
     * <p>
     * The number of instances with <code>NotApplicable</code> patches beyond the supported limit, which are not
     * reported by name to Systems Manager Inventory.
     * </p>
     * 
     * @return The number of instances with <code>NotApplicable</code> patches beyond the supported limit, which are not
     *         reported by name to Systems Manager Inventory.
     */
    public Integer instancesWithUnreportedNotApplicablePatches() {
        return instancesWithUnreportedNotApplicablePatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithInstalledPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithInstalledOtherPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithInstalledPendingRebootPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithInstalledRejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithMissingPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithFailedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithNotApplicablePatches());
        hashCode = 31 * hashCode + Objects.hashCode(instancesWithUnreportedNotApplicablePatches());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupStateResponse)) {
            return false;
        }
        DescribePatchGroupStateResponse other = (DescribePatchGroupStateResponse) obj;
        return Objects.equals(instances(), other.instances())
                && Objects.equals(instancesWithInstalledPatches(), other.instancesWithInstalledPatches())
                && Objects.equals(instancesWithInstalledOtherPatches(), other.instancesWithInstalledOtherPatches())
                && Objects.equals(instancesWithInstalledPendingRebootPatches(),
                        other.instancesWithInstalledPendingRebootPatches())
                && Objects.equals(instancesWithInstalledRejectedPatches(), other.instancesWithInstalledRejectedPatches())
                && Objects.equals(instancesWithMissingPatches(), other.instancesWithMissingPatches())
                && Objects.equals(instancesWithFailedPatches(), other.instancesWithFailedPatches())
                && Objects.equals(instancesWithNotApplicablePatches(), other.instancesWithNotApplicablePatches())
                && Objects.equals(instancesWithUnreportedNotApplicablePatches(),
                        other.instancesWithUnreportedNotApplicablePatches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePatchGroupStateResponse").add("Instances", instances())
                .add("InstancesWithInstalledPatches", instancesWithInstalledPatches())
                .add("InstancesWithInstalledOtherPatches", instancesWithInstalledOtherPatches())
                .add("InstancesWithInstalledPendingRebootPatches", instancesWithInstalledPendingRebootPatches())
                .add("InstancesWithInstalledRejectedPatches", instancesWithInstalledRejectedPatches())
                .add("InstancesWithMissingPatches", instancesWithMissingPatches())
                .add("InstancesWithFailedPatches", instancesWithFailedPatches())
                .add("InstancesWithNotApplicablePatches", instancesWithNotApplicablePatches())
                .add("InstancesWithUnreportedNotApplicablePatches", instancesWithUnreportedNotApplicablePatches()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "InstancesWithInstalledPatches":
            return Optional.ofNullable(clazz.cast(instancesWithInstalledPatches()));
        case "InstancesWithInstalledOtherPatches":
            return Optional.ofNullable(clazz.cast(instancesWithInstalledOtherPatches()));
        case "InstancesWithInstalledPendingRebootPatches":
            return Optional.ofNullable(clazz.cast(instancesWithInstalledPendingRebootPatches()));
        case "InstancesWithInstalledRejectedPatches":
            return Optional.ofNullable(clazz.cast(instancesWithInstalledRejectedPatches()));
        case "InstancesWithMissingPatches":
            return Optional.ofNullable(clazz.cast(instancesWithMissingPatches()));
        case "InstancesWithFailedPatches":
            return Optional.ofNullable(clazz.cast(instancesWithFailedPatches()));
        case "InstancesWithNotApplicablePatches":
            return Optional.ofNullable(clazz.cast(instancesWithNotApplicablePatches()));
        case "InstancesWithUnreportedNotApplicablePatches":
            return Optional.ofNullable(clazz.cast(instancesWithUnreportedNotApplicablePatches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchGroupStateResponse, T> g) {
        return obj -> g.apply((DescribePatchGroupStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePatchGroupStateResponse> {
        /**
         * <p>
         * The number of instances in the patch group.
         * </p>
         * 
         * @param instances
         *        The number of instances in the patch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Integer instances);

        /**
         * <p>
         * The number of instances with installed patches.
         * </p>
         * 
         * @param instancesWithInstalledPatches
         *        The number of instances with installed patches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches);

        /**
         * <p>
         * The number of instances with patches installed that aren't defined in the patch baseline.
         * </p>
         * 
         * @param instancesWithInstalledOtherPatches
         *        The number of instances with patches installed that aren't defined in the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param instancesWithInstalledPendingRebootPatches
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithInstalledPendingRebootPatches(Integer instancesWithInstalledPendingRebootPatches);

        /**
         * <p>
         * The number of instances with patches installed that are specified in a RejectedPatches list. Patches with a
         * status of <i>INSTALLED_REJECTED</i> were typically installed before they were added to a RejectedPatches
         * list.
         * </p>
         * <note>
         * <p>
         * If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction, the value of
         * InstancesWithInstalledRejectedPatches will always be 0 (zero).
         * </p>
         * </note>
         * 
         * @param instancesWithInstalledRejectedPatches
         *        The number of instances with patches installed that are specified in a RejectedPatches list. Patches
         *        with a status of <i>INSTALLED_REJECTED</i> were typically installed before they were added to a
         *        RejectedPatches list.</p> <note>
         *        <p>
         *        If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction, the value of
         *        InstancesWithInstalledRejectedPatches will always be 0 (zero).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches);

        /**
         * <p>
         * The number of instances with missing patches from the patch baseline.
         * </p>
         * 
         * @param instancesWithMissingPatches
         *        The number of instances with missing patches from the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithMissingPatches(Integer instancesWithMissingPatches);

        /**
         * <p>
         * The number of instances with patches from the patch baseline that failed to install.
         * </p>
         * 
         * @param instancesWithFailedPatches
         *        The number of instances with patches from the patch baseline that failed to install.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithFailedPatches(Integer instancesWithFailedPatches);

        /**
         * <p>
         * The number of instances with patches that aren't applicable.
         * </p>
         * 
         * @param instancesWithNotApplicablePatches
         *        The number of instances with patches that aren't applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches);

        /**
         * <p>
         * The number of instances with <code>NotApplicable</code> patches beyond the supported limit, which are not
         * reported by name to Systems Manager Inventory.
         * </p>
         * 
         * @param instancesWithUnreportedNotApplicablePatches
         *        The number of instances with <code>NotApplicable</code> patches beyond the supported limit, which are
         *        not reported by name to Systems Manager Inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private Integer instances;

        private Integer instancesWithInstalledPatches;

        private Integer instancesWithInstalledOtherPatches;

        private Integer instancesWithInstalledPendingRebootPatches;

        private Integer instancesWithInstalledRejectedPatches;

        private Integer instancesWithMissingPatches;

        private Integer instancesWithFailedPatches;

        private Integer instancesWithNotApplicablePatches;

        private Integer instancesWithUnreportedNotApplicablePatches;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupStateResponse model) {
            super(model);
            instances(model.instances);
            instancesWithInstalledPatches(model.instancesWithInstalledPatches);
            instancesWithInstalledOtherPatches(model.instancesWithInstalledOtherPatches);
            instancesWithInstalledPendingRebootPatches(model.instancesWithInstalledPendingRebootPatches);
            instancesWithInstalledRejectedPatches(model.instancesWithInstalledRejectedPatches);
            instancesWithMissingPatches(model.instancesWithMissingPatches);
            instancesWithFailedPatches(model.instancesWithFailedPatches);
            instancesWithNotApplicablePatches(model.instancesWithNotApplicablePatches);
            instancesWithUnreportedNotApplicablePatches(model.instancesWithUnreportedNotApplicablePatches);
        }

        public final Integer getInstances() {
            return instances;
        }

        @Override
        public final Builder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(Integer instances) {
            this.instances = instances;
        }

        public final Integer getInstancesWithInstalledPatches() {
            return instancesWithInstalledPatches;
        }

        @Override
        public final Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
            return this;
        }

        public final void setInstancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
        }

        public final Integer getInstancesWithInstalledOtherPatches() {
            return instancesWithInstalledOtherPatches;
        }

        @Override
        public final Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
            return this;
        }

        public final void setInstancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
        }

        public final Integer getInstancesWithInstalledPendingRebootPatches() {
            return instancesWithInstalledPendingRebootPatches;
        }

        @Override
        public final Builder instancesWithInstalledPendingRebootPatches(Integer instancesWithInstalledPendingRebootPatches) {
            this.instancesWithInstalledPendingRebootPatches = instancesWithInstalledPendingRebootPatches;
            return this;
        }

        public final void setInstancesWithInstalledPendingRebootPatches(Integer instancesWithInstalledPendingRebootPatches) {
            this.instancesWithInstalledPendingRebootPatches = instancesWithInstalledPendingRebootPatches;
        }

        public final Integer getInstancesWithInstalledRejectedPatches() {
            return instancesWithInstalledRejectedPatches;
        }

        @Override
        public final Builder instancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches) {
            this.instancesWithInstalledRejectedPatches = instancesWithInstalledRejectedPatches;
            return this;
        }

        public final void setInstancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches) {
            this.instancesWithInstalledRejectedPatches = instancesWithInstalledRejectedPatches;
        }

        public final Integer getInstancesWithMissingPatches() {
            return instancesWithMissingPatches;
        }

        @Override
        public final Builder instancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
            return this;
        }

        public final void setInstancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
        }

        public final Integer getInstancesWithFailedPatches() {
            return instancesWithFailedPatches;
        }

        @Override
        public final Builder instancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
            return this;
        }

        public final void setInstancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
        }

        public final Integer getInstancesWithNotApplicablePatches() {
            return instancesWithNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
            return this;
        }

        public final void setInstancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
        }

        public final Integer getInstancesWithUnreportedNotApplicablePatches() {
            return instancesWithUnreportedNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches) {
            this.instancesWithUnreportedNotApplicablePatches = instancesWithUnreportedNotApplicablePatches;
            return this;
        }

        public final void setInstancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches) {
            this.instancesWithUnreportedNotApplicablePatches = instancesWithUnreportedNotApplicablePatches;
        }

        @Override
        public DescribePatchGroupStateResponse build() {
            return new DescribePatchGroupStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
