/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more aggregators for viewing counts of OpsItems using different dimensions such as <code>Source</code>,
 * <code>CreatedTime</code>, or <code>Source and CreatedTime</code>, to name a few.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsAggregator implements SdkPojo, Serializable, ToCopyableBuilder<OpsAggregator.Builder, OpsAggregator> {
    private static final SdkField<String> AGGREGATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OpsAggregator::aggregatorType)).setter(setter(Builder::aggregatorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorType").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OpsAggregator::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OpsAggregator::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<Map<String, String>> VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(OpsAggregator::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<OpsFilter>> FILTERS_FIELD = SdkField
            .<List<OpsFilter>> builder(MarshallingType.LIST)
            .getter(getter(OpsAggregator::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OpsAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<OpsAggregator>> builder(MarshallingType.LIST)
            .getter(getter(OpsAggregator::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_TYPE_FIELD,
            TYPE_NAME_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_FIELD, FILTERS_FIELD, AGGREGATORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aggregatorType;

    private final String typeName;

    private final String attributeName;

    private final Map<String, String> values;

    private final List<OpsFilter> filters;

    private final List<OpsAggregator> aggregators;

    private OpsAggregator(BuilderImpl builder) {
        this.aggregatorType = builder.aggregatorType;
        this.typeName = builder.typeName;
        this.attributeName = builder.attributeName;
        this.values = builder.values;
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
    }

    /**
     * <p>
     * Either a Range or Count aggregator for limiting an OpsItem summary.
     * </p>
     * 
     * @return Either a Range or Count aggregator for limiting an OpsItem summary.
     */
    public String aggregatorType() {
        return aggregatorType;
    }

    /**
     * <p>
     * The data type name to use for viewing counts of OpsItems.
     * </p>
     * 
     * @return The data type name to use for viewing counts of OpsItems.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The name of an OpsItem attribute on which to limit the count of OpsItems.
     * </p>
     * 
     * @return The name of an OpsItem attribute on which to limit the count of OpsItems.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The aggregator value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The aggregator value.
     */
    public Map<String, String> values() {
        return values;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregator filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The aggregator filters.
     */
    public List<OpsFilter> filters() {
        return filters;
    }

    /**
     * Returns true if the Aggregators property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAggregators() {
        return aggregators != null && !(aggregators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A nested aggregator for viewing counts of OpsItems.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAggregators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A nested aggregator for viewing counts of OpsItems.
     */
    public List<OpsAggregator> aggregators() {
        return aggregators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregatorType());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(aggregators());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsAggregator)) {
            return false;
        }
        OpsAggregator other = (OpsAggregator) obj;
        return Objects.equals(aggregatorType(), other.aggregatorType()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(attributeName(), other.attributeName()) && Objects.equals(values(), other.values())
                && Objects.equals(filters(), other.filters()) && Objects.equals(aggregators(), other.aggregators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OpsAggregator").add("AggregatorType", aggregatorType()).add("TypeName", typeName())
                .add("AttributeName", attributeName()).add("Values", values()).add("Filters", filters())
                .add("Aggregators", aggregators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregatorType":
            return Optional.ofNullable(clazz.cast(aggregatorType()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsAggregator, T> g) {
        return obj -> g.apply((OpsAggregator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsAggregator> {
        /**
         * <p>
         * Either a Range or Count aggregator for limiting an OpsItem summary.
         * </p>
         * 
         * @param aggregatorType
         *        Either a Range or Count aggregator for limiting an OpsItem summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorType(String aggregatorType);

        /**
         * <p>
         * The data type name to use for viewing counts of OpsItems.
         * </p>
         * 
         * @param typeName
         *        The data type name to use for viewing counts of OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The name of an OpsItem attribute on which to limit the count of OpsItems.
         * </p>
         * 
         * @param attributeName
         *        The name of an OpsItem attribute on which to limit the count of OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The aggregator value.
         * </p>
         * 
         * @param values
         *        The aggregator value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Map<String, String> values);

        /**
         * <p>
         * The aggregator filters.
         * </p>
         * 
         * @param filters
         *        The aggregator filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OpsFilter> filters);

        /**
         * <p>
         * The aggregator filters.
         * </p>
         * 
         * @param filters
         *        The aggregator filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OpsFilter... filters);

        /**
         * <p>
         * The aggregator filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OpsFilter>.Builder} avoiding the need to
         * create one manually via {@link List<OpsFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<OpsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<OpsFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<OpsFilter>)
         */
        Builder filters(Consumer<OpsFilter.Builder>... filters);

        /**
         * <p>
         * A nested aggregator for viewing counts of OpsItems.
         * </p>
         * 
         * @param aggregators
         *        A nested aggregator for viewing counts of OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<OpsAggregator> aggregators);

        /**
         * <p>
         * A nested aggregator for viewing counts of OpsItems.
         * </p>
         * 
         * @param aggregators
         *        A nested aggregator for viewing counts of OpsItems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(OpsAggregator... aggregators);

        /**
         * <p>
         * A nested aggregator for viewing counts of OpsItems.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OpsAggregator>.Builder} avoiding the need
         * to create one manually via {@link List<OpsAggregator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsAggregator>.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregators(List<OpsAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on {@link List<OpsAggregator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(List<OpsAggregator>)
         */
        Builder aggregators(Consumer<Builder>... aggregators);
    }

    static final class BuilderImpl implements Builder {
        private String aggregatorType;

        private String typeName;

        private String attributeName;

        private Map<String, String> values = DefaultSdkAutoConstructMap.getInstance();

        private List<OpsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<OpsAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsAggregator model) {
            aggregatorType(model.aggregatorType);
            typeName(model.typeName);
            attributeName(model.attributeName);
            values(model.values);
            filters(model.filters);
            aggregators(model.aggregators);
        }

        public final String getAggregatorType() {
            return aggregatorType;
        }

        @Override
        public final Builder aggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
            return this;
        }

        public final void setAggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Map<String, String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Map<String, String> values) {
            this.values = OpsAggregatorValueMapCopier.copy(values);
            return this;
        }

        public final void setValues(Map<String, String> values) {
            this.values = OpsAggregatorValueMapCopier.copy(values);
        }

        public final Collection<OpsFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(OpsFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<OpsFilter> filters) {
            this.filters = OpsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OpsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OpsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OpsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<OpsFilter.BuilderImpl> filters) {
            this.filters = OpsFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<Builder> getAggregators() {
            return aggregators != null ? aggregators.stream().map(OpsAggregator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aggregators(Collection<OpsAggregator> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(OpsAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> OpsAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public OpsAggregator build() {
            return new OpsAggregator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
