/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more filters. Use a filter to return a more specific list of results.
 * </p>
 * <important>
 * <p>
 * The <code>ParameterStringFilter</code> object is used by the <a>DescribeParameters</a> and <a>GetParametersByPath</a>
 * API actions. However, not all of the pattern values listed for <code>Key</code> can be used with both actions.
 * </p>
 * <p>
 * For <code>DescribeActions</code>, all of the listed patterns are valid, with the exception of <code>Label</code>.
 * </p>
 * <p>
 * For <code>GetParametersByPath</code>, the following patterns listed for <code>Key</code> are not valid:
 * <code>Name</code>, <code>Path</code>, and <code>Tier</code>.
 * </p>
 * <p>
 * For examples of CLI commands demonstrating valid parameter filter constructions, see <a
 * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems
 * Manager Parameters</a> in the <i>AWS Systems Manager User Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterStringFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterStringFilter.Builder, ParameterStringFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterStringFilter::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ParameterStringFilter::option)).setter(setter(Builder::option))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Option").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ParameterStringFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, OPTION_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String option;

    private final List<String> values;

    private ParameterStringFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.option = builder.option;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * For all filters used with <a>DescribeParameters</a>, valid options include <code>Equals</code> and
     * <code>BeginsWith</code>. The <code>Name</code> filter additionally supports the <code>Contains</code> option.
     * (Exception: For filters using the key <code>Path</code>, valid options include <code>Recursive</code> and
     * <code>OneLevel</code>.)
     * </p>
     * <p>
     * For filters used with <a>GetParametersByPath</a>, valid options include <code>Equals</code> and
     * <code>BeginsWith</code>. (Exception: For filters using the key <code>Label</code>, the only valid option is
     * <code>Equals</code>.)
     * </p>
     * 
     * @return For all filters used with <a>DescribeParameters</a>, valid options include <code>Equals</code> and
     *         <code>BeginsWith</code>. The <code>Name</code> filter additionally supports the <code>Contains</code>
     *         option. (Exception: For filters using the key <code>Path</code>, valid options include
     *         <code>Recursive</code> and <code>OneLevel</code>.)</p>
     *         <p>
     *         For filters used with <a>GetParametersByPath</a>, valid options include <code>Equals</code> and
     *         <code>BeginsWith</code>. (Exception: For filters using the key <code>Label</code>, the only valid option
     *         is <code>Equals</code>.)
     */
    public String option() {
        return option;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value you want to search for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value you want to search for.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(option());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterStringFilter)) {
            return false;
        }
        ParameterStringFilter other = (ParameterStringFilter) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(option(), other.option())
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterStringFilter").add("Key", key()).add("Option", option()).add("Values", values())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Option":
            return Optional.ofNullable(clazz.cast(option()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterStringFilter, T> g) {
        return obj -> g.apply((ParameterStringFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterStringFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * For all filters used with <a>DescribeParameters</a>, valid options include <code>Equals</code> and
         * <code>BeginsWith</code>. The <code>Name</code> filter additionally supports the <code>Contains</code> option.
         * (Exception: For filters using the key <code>Path</code>, valid options include <code>Recursive</code> and
         * <code>OneLevel</code>.)
         * </p>
         * <p>
         * For filters used with <a>GetParametersByPath</a>, valid options include <code>Equals</code> and
         * <code>BeginsWith</code>. (Exception: For filters using the key <code>Label</code>, the only valid option is
         * <code>Equals</code>.)
         * </p>
         * 
         * @param option
         *        For all filters used with <a>DescribeParameters</a>, valid options include <code>Equals</code> and
         *        <code>BeginsWith</code>. The <code>Name</code> filter additionally supports the <code>Contains</code>
         *        option. (Exception: For filters using the key <code>Path</code>, valid options include
         *        <code>Recursive</code> and <code>OneLevel</code>.)</p>
         *        <p>
         *        For filters used with <a>GetParametersByPath</a>, valid options include <code>Equals</code> and
         *        <code>BeginsWith</code>. (Exception: For filters using the key <code>Label</code>, the only valid
         *        option is <code>Equals</code>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder option(String option);

        /**
         * <p>
         * The value you want to search for.
         * </p>
         * 
         * @param values
         *        The value you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value you want to search for.
         * </p>
         * 
         * @param values
         *        The value you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String option;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterStringFilter model) {
            key(model.key);
            option(model.option);
            values(model.values);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getOption() {
            return option;
        }

        @Override
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParameterStringFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParameterStringFilterValueListCopier.copy(values);
        }

        @Override
        public ParameterStringFilter build() {
            return new ParameterStringFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
