/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of resources that are compliant. The summary is organized according to the resource count for each
 * compliance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompliantSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompliantSummary.Builder, CompliantSummary> {
    private static final SdkField<Integer> COMPLIANT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CompliantSummary::compliantCount)).setter(setter(Builder::compliantCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantCount").build()).build();

    private static final SdkField<SeveritySummary> SEVERITY_SUMMARY_FIELD = SdkField
            .<SeveritySummary> builder(MarshallingType.SDK_POJO).getter(getter(CompliantSummary::severitySummary))
            .setter(setter(Builder::severitySummary)).constructor(SeveritySummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeveritySummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANT_COUNT_FIELD,
            SEVERITY_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer compliantCount;

    private final SeveritySummary severitySummary;

    private CompliantSummary(BuilderImpl builder) {
        this.compliantCount = builder.compliantCount;
        this.severitySummary = builder.severitySummary;
    }

    /**
     * <p>
     * The total number of resources that are compliant.
     * </p>
     * 
     * @return The total number of resources that are compliant.
     */
    public Integer compliantCount() {
        return compliantCount;
    }

    /**
     * <p>
     * A summary of the compliance severity by compliance type.
     * </p>
     * 
     * @return A summary of the compliance severity by compliance type.
     */
    public SeveritySummary severitySummary() {
        return severitySummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(severitySummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompliantSummary)) {
            return false;
        }
        CompliantSummary other = (CompliantSummary) obj;
        return Objects.equals(compliantCount(), other.compliantCount())
                && Objects.equals(severitySummary(), other.severitySummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CompliantSummary").add("CompliantCount", compliantCount())
                .add("SeveritySummary", severitySummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompliantCount":
            return Optional.ofNullable(clazz.cast(compliantCount()));
        case "SeveritySummary":
            return Optional.ofNullable(clazz.cast(severitySummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompliantSummary, T> g) {
        return obj -> g.apply((CompliantSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompliantSummary> {
        /**
         * <p>
         * The total number of resources that are compliant.
         * </p>
         * 
         * @param compliantCount
         *        The total number of resources that are compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliantCount(Integer compliantCount);

        /**
         * <p>
         * A summary of the compliance severity by compliance type.
         * </p>
         * 
         * @param severitySummary
         *        A summary of the compliance severity by compliance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severitySummary(SeveritySummary severitySummary);

        /**
         * <p>
         * A summary of the compliance severity by compliance type.
         * </p>
         * This is a convenience that creates an instance of the {@link SeveritySummary.Builder} avoiding the need to
         * create one manually via {@link SeveritySummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SeveritySummary.Builder#build()} is called immediately and its
         * result is passed to {@link #severitySummary(SeveritySummary)}.
         * 
         * @param severitySummary
         *        a consumer that will call methods on {@link SeveritySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severitySummary(SeveritySummary)
         */
        default Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return severitySummary(SeveritySummary.builder().applyMutation(severitySummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer compliantCount;

        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CompliantSummary model) {
            compliantCount(model.compliantCount);
            severitySummary(model.severitySummary);
        }

        public final Integer getCompliantCount() {
            return compliantCount;
        }

        @Override
        public final Builder compliantCount(Integer compliantCount) {
            this.compliantCount = compliantCount;
            return this;
        }

        public final void setCompliantCount(Integer compliantCount) {
            this.compliantCount = compliantCount;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return severitySummary != null ? severitySummary.toBuilder() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        @Override
        public CompliantSummary build() {
            return new CompliantSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
