/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the delete operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryDeletionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryDeletionSummary.Builder, InventoryDeletionSummary> {
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InventoryDeletionSummary::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<Integer> REMAINING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InventoryDeletionSummary::remainingCount)).setter(setter(Builder::remainingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingCount").build()).build();

    private static final SdkField<List<InventoryDeletionSummaryItem>> SUMMARY_ITEMS_FIELD = SdkField
            .<List<InventoryDeletionSummaryItem>> builder(MarshallingType.LIST)
            .getter(getter(InventoryDeletionSummary::summaryItems))
            .setter(setter(Builder::summaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryDeletionSummaryItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryDeletionSummaryItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COUNT_FIELD,
            REMAINING_COUNT_FIELD, SUMMARY_ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalCount;

    private final Integer remainingCount;

    private final List<InventoryDeletionSummaryItem> summaryItems;

    private InventoryDeletionSummary(BuilderImpl builder) {
        this.totalCount = builder.totalCount;
        this.remainingCount = builder.remainingCount;
        this.summaryItems = builder.summaryItems;
    }

    /**
     * <p>
     * The total number of items to delete. This count does not change during the delete operation.
     * </p>
     * 
     * @return The total number of items to delete. This count does not change during the delete operation.
     */
    public Integer totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * Remaining number of items to delete.
     * </p>
     * 
     * @return Remaining number of items to delete.
     */
    public Integer remainingCount() {
        return remainingCount;
    }

    /**
     * Returns true if the SummaryItems property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSummaryItems() {
        return summaryItems != null && !(summaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of counts and versions for deleted items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSummaryItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of counts and versions for deleted items.
     */
    public List<InventoryDeletionSummaryItem> summaryItems() {
        return summaryItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(remainingCount());
        hashCode = 31 * hashCode + Objects.hashCode(summaryItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDeletionSummary)) {
            return false;
        }
        InventoryDeletionSummary other = (InventoryDeletionSummary) obj;
        return Objects.equals(totalCount(), other.totalCount()) && Objects.equals(remainingCount(), other.remainingCount())
                && Objects.equals(summaryItems(), other.summaryItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InventoryDeletionSummary").add("TotalCount", totalCount())
                .add("RemainingCount", remainingCount()).add("SummaryItems", summaryItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "RemainingCount":
            return Optional.ofNullable(clazz.cast(remainingCount()));
        case "SummaryItems":
            return Optional.ofNullable(clazz.cast(summaryItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryDeletionSummary, T> g) {
        return obj -> g.apply((InventoryDeletionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryDeletionSummary> {
        /**
         * <p>
         * The total number of items to delete. This count does not change during the delete operation.
         * </p>
         * 
         * @param totalCount
         *        The total number of items to delete. This count does not change during the delete operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * Remaining number of items to delete.
         * </p>
         * 
         * @param remainingCount
         *        Remaining number of items to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingCount(Integer remainingCount);

        /**
         * <p>
         * A list of counts and versions for deleted items.
         * </p>
         * 
         * @param summaryItems
         *        A list of counts and versions for deleted items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryItems(Collection<InventoryDeletionSummaryItem> summaryItems);

        /**
         * <p>
         * A list of counts and versions for deleted items.
         * </p>
         * 
         * @param summaryItems
         *        A list of counts and versions for deleted items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryItems(InventoryDeletionSummaryItem... summaryItems);

        /**
         * <p>
         * A list of counts and versions for deleted items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InventoryDeletionSummaryItem>.Builder}
         * avoiding the need to create one manually via {@link List<InventoryDeletionSummaryItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryDeletionSummaryItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #summaryItems(List<InventoryDeletionSummaryItem>)}.
         * 
         * @param summaryItems
         *        a consumer that will call methods on {@link List<InventoryDeletionSummaryItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryItems(List<InventoryDeletionSummaryItem>)
         */
        Builder summaryItems(Consumer<InventoryDeletionSummaryItem.Builder>... summaryItems);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalCount;

        private Integer remainingCount;

        private List<InventoryDeletionSummaryItem> summaryItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDeletionSummary model) {
            totalCount(model.totalCount);
            remainingCount(model.remainingCount);
            summaryItems(model.summaryItems);
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public final Integer getRemainingCount() {
            return remainingCount;
        }

        @Override
        public final Builder remainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
            return this;
        }

        public final void setRemainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
        }

        public final Collection<InventoryDeletionSummaryItem.Builder> getSummaryItems() {
            return summaryItems != null ? summaryItems.stream().map(InventoryDeletionSummaryItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaryItems(Collection<InventoryDeletionSummaryItem> summaryItems) {
            this.summaryItems = InventoryDeletionSummaryItemsCopier.copy(summaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(InventoryDeletionSummaryItem... summaryItems) {
            summaryItems(Arrays.asList(summaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(Consumer<InventoryDeletionSummaryItem.Builder>... summaryItems) {
            summaryItems(Stream.of(summaryItems).map(c -> InventoryDeletionSummaryItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSummaryItems(Collection<InventoryDeletionSummaryItem.BuilderImpl> summaryItems) {
            this.summaryItems = InventoryDeletionSummaryItemsCopier.copyFromBuilder(summaryItems);
        }

        @Override
        public InventoryDeletionSummary build() {
            return new InventoryDeletionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
