/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommandInvocationsRequest extends SsmRequest implements
        ToCopyableBuilder<ListCommandInvocationsRequest.Builder, ListCommandInvocationsRequest> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCommandInvocationsRequest::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCommandInvocationsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListCommandInvocationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCommandInvocationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<CommandFilter>> FILTERS_FIELD = SdkField
            .<List<CommandFilter>> builder(MarshallingType.LIST)
            .getter(getter(ListCommandInvocationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListCommandInvocationsRequest::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            INSTANCE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD, DETAILS_FIELD));

    private final String commandId;

    private final String instanceId;

    private final Integer maxResults;

    private final String nextToken;

    private final List<CommandFilter> filters;

    private final Boolean details;

    private ListCommandInvocationsRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
        this.details = builder.details;
    }

    /**
     * <p>
     * (Optional) The invocations for a specific command ID.
     * </p>
     * 
     * @return (Optional) The invocations for a specific command ID.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * (Optional) The command execution details for a specific instance ID.
     * </p>
     * 
     * @return (Optional) The command execution details for a specific instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * (Optional) The maximum number of items to return for this call. The call also returns a token that you can
     * specify in a subsequent call to get the next set of results.
     * </p>
     * 
     * @return (Optional) The maximum number of items to return for this call. The call also returns a token that you
     *         can specify in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
     * <code>DocumentName</code> filter is not supported for ListCommandInvocations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
     *         <code>DocumentName</code> filter is not supported for ListCommandInvocations.
     */
    public List<CommandFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * (Optional) If set this returns the response of the command executions and any command output. By default this is
     * set to False.
     * </p>
     * 
     * @return (Optional) If set this returns the response of the command executions and any command output. By default
     *         this is set to False.
     */
    public Boolean details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsRequest)) {
            return false;
        }
        ListCommandInvocationsRequest other = (ListCommandInvocationsRequest) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(filters(), other.filters()) && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCommandInvocationsRequest").add("CommandId", commandId()).add("InstanceId", instanceId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Filters", filters())
                .add("Details", details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCommandInvocationsRequest, T> g) {
        return obj -> g.apply((ListCommandInvocationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCommandInvocationsRequest> {
        /**
         * <p>
         * (Optional) The invocations for a specific command ID.
         * </p>
         * 
         * @param commandId
         *        (Optional) The invocations for a specific command ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * (Optional) The command execution details for a specific instance ID.
         * </p>
         * 
         * @param instanceId
         *        (Optional) The command execution details for a specific instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * (Optional) The maximum number of items to return for this call. The call also returns a token that you can
         * specify in a subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        (Optional) The maximum number of items to return for this call. The call also returns a token that you
         *        can specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
         * <code>DocumentName</code> filter is not supported for ListCommandInvocations.
         * </p>
         * 
         * @param filters
         *        (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
         *        <code>DocumentName</code> filter is not supported for ListCommandInvocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<CommandFilter> filters);

        /**
         * <p>
         * (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
         * <code>DocumentName</code> filter is not supported for ListCommandInvocations.
         * </p>
         * 
         * @param filters
         *        (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
         *        <code>DocumentName</code> filter is not supported for ListCommandInvocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(CommandFilter... filters);

        /**
         * <p>
         * (Optional) One or more filters. Use a filter to return a more specific list of results. Note that the
         * <code>DocumentName</code> filter is not supported for ListCommandInvocations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CommandFilter>.Builder} avoiding the need
         * to create one manually via {@link List<CommandFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CommandFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<CommandFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<CommandFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<CommandFilter>)
         */
        Builder filters(Consumer<CommandFilter.Builder>... filters);

        /**
         * <p>
         * (Optional) If set this returns the response of the command executions and any command output. By default this
         * is set to False.
         * </p>
         * 
         * @param details
         *        (Optional) If set this returns the response of the command executions and any command output. By
         *        default this is set to False.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Boolean details);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private Integer maxResults;

        private String nextToken;

        private List<CommandFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Boolean details;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandInvocationsRequest model) {
            super(model);
            commandId(model.commandId);
            instanceId(model.instanceId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
            details(model.details);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CommandFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(CommandFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<CommandFilter> filters) {
            this.filters = CommandFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(CommandFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<CommandFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> CommandFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<CommandFilter.BuilderImpl> filters) {
            this.filters = CommandFilterListCopier.copyFromBuilder(filters);
        }

        public final Boolean getDetails() {
            return details;
        }

        @Override
        public final Builder details(Boolean details) {
            this.details = details;
            return this;
        }

        public final void setDetails(Boolean details) {
            this.details = details;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCommandInvocationsRequest build() {
            return new ListCommandInvocationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
