/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPatchBaselineForPatchGroupResponse extends SsmResponse implements
        ToCopyableBuilder<GetPatchBaselineForPatchGroupResponse.Builder, GetPatchBaselineForPatchGroupResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPatchBaselineForPatchGroupResponse::baselineId)).setter(setter(Builder::baselineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()).build();

    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPatchBaselineForPatchGroupResponse::patchGroup)).setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPatchBaselineForPatchGroupResponse::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD,
            PATCH_GROUP_FIELD, OPERATING_SYSTEM_FIELD));

    private final String baselineId;

    private final String patchGroup;

    private final String operatingSystem;

    private GetPatchBaselineForPatchGroupResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.patchGroup = builder.patchGroup;
        this.operatingSystem = builder.operatingSystem;
    }

    /**
     * <p>
     * The ID of the patch baseline that should be used for the patch group.
     * </p>
     * 
     * @return The ID of the patch baseline that should be used for the patch group.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch group.
     * </p>
     * 
     * @return The name of the patch group.
     */
    public String patchGroup() {
        return patchGroup;
    }

    /**
     * <p>
     * The operating system rule specified for patch groups using the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The operating system rule specified for patch groups using the patch baseline.
     * @see OperatingSystem
     */
    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * The operating system rule specified for patch groups using the patch baseline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return The operating system rule specified for patch groups using the patch baseline.
     * @see OperatingSystem
     */
    public String operatingSystemAsString() {
        return operatingSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPatchBaselineForPatchGroupResponse)) {
            return false;
        }
        GetPatchBaselineForPatchGroupResponse other = (GetPatchBaselineForPatchGroupResponse) obj;
        return Objects.equals(baselineId(), other.baselineId()) && Objects.equals(patchGroup(), other.patchGroup())
                && Objects.equals(operatingSystemAsString(), other.operatingSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPatchBaselineForPatchGroupResponse").add("BaselineId", baselineId())
                .add("PatchGroup", patchGroup()).add("OperatingSystem", operatingSystemAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.ofNullable(clazz.cast(baselineId()));
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPatchBaselineForPatchGroupResponse, T> g) {
        return obj -> g.apply((GetPatchBaselineForPatchGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPatchBaselineForPatchGroupResponse> {
        /**
         * <p>
         * The ID of the patch baseline that should be used for the patch group.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline that should be used for the patch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch group.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);

        /**
         * <p>
         * The operating system rule specified for patch groups using the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system rule specified for patch groups using the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The operating system rule specified for patch groups using the patch baseline.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system rule specified for patch groups using the patch baseline.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String baselineId;

        private String patchGroup;

        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPatchBaselineForPatchGroupResponse model) {
            super(model);
            baselineId(model.baselineId);
            patchGroup(model.patchGroup);
            operatingSystem(model.operatingSystem);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final String getOperatingSystemAsString() {
            return operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public GetPatchBaselineForPatchGroupResponse build() {
            return new GetPatchBaselineForPatchGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
