/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys;
import software.amazon.awssdk.services.ssm.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeActivationsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeActivationsFilter> {
    private static final SdkField<String> FILTER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeActivationsFilter.getter(DescribeActivationsFilter::filterKeyAsString)).setter(DescribeActivationsFilter.setter(Builder::filterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterKey").build()}).build();
    private static final SdkField<List<String>> FILTER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeActivationsFilter.getter(DescribeActivationsFilter::filterValues)).setter(DescribeActivationsFilter.setter(Builder::filterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_KEY_FIELD, FILTER_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterKey;
    private final List<String> filterValues;

    private DescribeActivationsFilter(BuilderImpl builder) {
        this.filterKey = builder.filterKey;
        this.filterValues = builder.filterValues;
    }

    public DescribeActivationsFilterKeys filterKey() {
        return DescribeActivationsFilterKeys.fromValue(this.filterKey);
    }

    public String filterKeyAsString() {
        return this.filterKey;
    }

    public boolean hasFilterValues() {
        return this.filterValues != null && !(this.filterValues instanceof SdkAutoConstructList);
    }

    public List<String> filterValues() {
        return this.filterValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivationsFilter)) {
            return false;
        }
        DescribeActivationsFilter other = (DescribeActivationsFilter)obj;
        return Objects.equals(this.filterKeyAsString(), other.filterKeyAsString()) && Objects.equals(this.filterValues(), other.filterValues());
    }

    public String toString() {
        return ToString.builder((String)"DescribeActivationsFilter").add("FilterKey", (Object)this.filterKeyAsString()).add("FilterValues", this.filterValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterKey": {
                return Optional.ofNullable(clazz.cast(this.filterKeyAsString()));
            }
            case "FilterValues": {
                return Optional.ofNullable(clazz.cast(this.filterValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivationsFilter, T> g) {
        return obj -> g.apply((DescribeActivationsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterKey;
        private List<String> filterValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivationsFilter model) {
            this.filterKey(model.filterKey);
            this.filterValues(model.filterValues);
        }

        public final String getFilterKeyAsString() {
            return this.filterKey;
        }

        @Override
        public final Builder filterKey(String filterKey) {
            this.filterKey = filterKey;
            return this;
        }

        @Override
        public final Builder filterKey(DescribeActivationsFilterKeys filterKey) {
            this.filterKey(filterKey == null ? null : filterKey.toString());
            return this;
        }

        public final void setFilterKey(String filterKey) {
            this.filterKey = filterKey;
        }

        public final Collection<String> getFilterValues() {
            return this.filterValues;
        }

        @Override
        public final Builder filterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValues(String ... filterValues) {
            this.filterValues(Arrays.asList(filterValues));
            return this;
        }

        public final void setFilterValues(Collection<String> filterValues) {
            this.filterValues = StringListCopier.copy(filterValues);
        }

        public DescribeActivationsFilter build() {
            return new DescribeActivationsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeActivationsFilter> {
        public Builder filterKey(String var1);

        public Builder filterKey(DescribeActivationsFilterKeys var1);

        public Builder filterValues(Collection<String> var1);

        public Builder filterValues(String ... var1);
    }
}

