/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of managed instances found for each patch severity level defined in the request filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeveritySummary implements SdkPojo, Serializable, ToCopyableBuilder<SeveritySummary.Builder, SeveritySummary> {
    private static final SdkField<Integer> CRITICAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SeveritySummary::criticalCount)).setter(setter(Builder::criticalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CriticalCount").build()).build();

    private static final SdkField<Integer> HIGH_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SeveritySummary::highCount)).setter(setter(Builder::highCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HighCount").build()).build();

    private static final SdkField<Integer> MEDIUM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SeveritySummary::mediumCount)).setter(setter(Builder::mediumCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediumCount").build()).build();

    private static final SdkField<Integer> LOW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SeveritySummary::lowCount)).setter(setter(Builder::lowCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowCount").build()).build();

    private static final SdkField<Integer> INFORMATIONAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SeveritySummary::informationalCount)).setter(setter(Builder::informationalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InformationalCount").build())
            .build();

    private static final SdkField<Integer> UNSPECIFIED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SeveritySummary::unspecifiedCount)).setter(setter(Builder::unspecifiedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnspecifiedCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITICAL_COUNT_FIELD,
            HIGH_COUNT_FIELD, MEDIUM_COUNT_FIELD, LOW_COUNT_FIELD, INFORMATIONAL_COUNT_FIELD, UNSPECIFIED_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer criticalCount;

    private final Integer highCount;

    private final Integer mediumCount;

    private final Integer lowCount;

    private final Integer informationalCount;

    private final Integer unspecifiedCount;

    private SeveritySummary(BuilderImpl builder) {
        this.criticalCount = builder.criticalCount;
        this.highCount = builder.highCount;
        this.mediumCount = builder.mediumCount;
        this.lowCount = builder.lowCount;
        this.informationalCount = builder.informationalCount;
        this.unspecifiedCount = builder.unspecifiedCount;
    }

    /**
     * <p>
     * The total number of resources or compliance items that have a severity level of critical. Critical severity is
     * determined by the organization that published the compliance items.
     * </p>
     * 
     * @return The total number of resources or compliance items that have a severity level of critical. Critical
     *         severity is determined by the organization that published the compliance items.
     */
    public Integer criticalCount() {
        return criticalCount;
    }

    /**
     * <p>
     * The total number of resources or compliance items that have a severity level of high. High severity is determined
     * by the organization that published the compliance items.
     * </p>
     * 
     * @return The total number of resources or compliance items that have a severity level of high. High severity is
     *         determined by the organization that published the compliance items.
     */
    public Integer highCount() {
        return highCount;
    }

    /**
     * <p>
     * The total number of resources or compliance items that have a severity level of medium. Medium severity is
     * determined by the organization that published the compliance items.
     * </p>
     * 
     * @return The total number of resources or compliance items that have a severity level of medium. Medium severity
     *         is determined by the organization that published the compliance items.
     */
    public Integer mediumCount() {
        return mediumCount;
    }

    /**
     * <p>
     * The total number of resources or compliance items that have a severity level of low. Low severity is determined
     * by the organization that published the compliance items.
     * </p>
     * 
     * @return The total number of resources or compliance items that have a severity level of low. Low severity is
     *         determined by the organization that published the compliance items.
     */
    public Integer lowCount() {
        return lowCount;
    }

    /**
     * <p>
     * The total number of resources or compliance items that have a severity level of informational. Informational
     * severity is determined by the organization that published the compliance items.
     * </p>
     * 
     * @return The total number of resources or compliance items that have a severity level of informational.
     *         Informational severity is determined by the organization that published the compliance items.
     */
    public Integer informationalCount() {
        return informationalCount;
    }

    /**
     * <p>
     * The total number of resources or compliance items that have a severity level of unspecified. Unspecified severity
     * is determined by the organization that published the compliance items.
     * </p>
     * 
     * @return The total number of resources or compliance items that have a severity level of unspecified. Unspecified
     *         severity is determined by the organization that published the compliance items.
     */
    public Integer unspecifiedCount() {
        return unspecifiedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(criticalCount());
        hashCode = 31 * hashCode + Objects.hashCode(highCount());
        hashCode = 31 * hashCode + Objects.hashCode(mediumCount());
        hashCode = 31 * hashCode + Objects.hashCode(lowCount());
        hashCode = 31 * hashCode + Objects.hashCode(informationalCount());
        hashCode = 31 * hashCode + Objects.hashCode(unspecifiedCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeveritySummary)) {
            return false;
        }
        SeveritySummary other = (SeveritySummary) obj;
        return Objects.equals(criticalCount(), other.criticalCount()) && Objects.equals(highCount(), other.highCount())
                && Objects.equals(mediumCount(), other.mediumCount()) && Objects.equals(lowCount(), other.lowCount())
                && Objects.equals(informationalCount(), other.informationalCount())
                && Objects.equals(unspecifiedCount(), other.unspecifiedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SeveritySummary").add("CriticalCount", criticalCount()).add("HighCount", highCount())
                .add("MediumCount", mediumCount()).add("LowCount", lowCount()).add("InformationalCount", informationalCount())
                .add("UnspecifiedCount", unspecifiedCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CriticalCount":
            return Optional.ofNullable(clazz.cast(criticalCount()));
        case "HighCount":
            return Optional.ofNullable(clazz.cast(highCount()));
        case "MediumCount":
            return Optional.ofNullable(clazz.cast(mediumCount()));
        case "LowCount":
            return Optional.ofNullable(clazz.cast(lowCount()));
        case "InformationalCount":
            return Optional.ofNullable(clazz.cast(informationalCount()));
        case "UnspecifiedCount":
            return Optional.ofNullable(clazz.cast(unspecifiedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeveritySummary, T> g) {
        return obj -> g.apply((SeveritySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeveritySummary> {
        /**
         * <p>
         * The total number of resources or compliance items that have a severity level of critical. Critical severity
         * is determined by the organization that published the compliance items.
         * </p>
         * 
         * @param criticalCount
         *        The total number of resources or compliance items that have a severity level of critical. Critical
         *        severity is determined by the organization that published the compliance items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticalCount(Integer criticalCount);

        /**
         * <p>
         * The total number of resources or compliance items that have a severity level of high. High severity is
         * determined by the organization that published the compliance items.
         * </p>
         * 
         * @param highCount
         *        The total number of resources or compliance items that have a severity level of high. High severity is
         *        determined by the organization that published the compliance items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highCount(Integer highCount);

        /**
         * <p>
         * The total number of resources or compliance items that have a severity level of medium. Medium severity is
         * determined by the organization that published the compliance items.
         * </p>
         * 
         * @param mediumCount
         *        The total number of resources or compliance items that have a severity level of medium. Medium
         *        severity is determined by the organization that published the compliance items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediumCount(Integer mediumCount);

        /**
         * <p>
         * The total number of resources or compliance items that have a severity level of low. Low severity is
         * determined by the organization that published the compliance items.
         * </p>
         * 
         * @param lowCount
         *        The total number of resources or compliance items that have a severity level of low. Low severity is
         *        determined by the organization that published the compliance items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowCount(Integer lowCount);

        /**
         * <p>
         * The total number of resources or compliance items that have a severity level of informational. Informational
         * severity is determined by the organization that published the compliance items.
         * </p>
         * 
         * @param informationalCount
         *        The total number of resources or compliance items that have a severity level of informational.
         *        Informational severity is determined by the organization that published the compliance items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder informationalCount(Integer informationalCount);

        /**
         * <p>
         * The total number of resources or compliance items that have a severity level of unspecified. Unspecified
         * severity is determined by the organization that published the compliance items.
         * </p>
         * 
         * @param unspecifiedCount
         *        The total number of resources or compliance items that have a severity level of unspecified.
         *        Unspecified severity is determined by the organization that published the compliance items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unspecifiedCount(Integer unspecifiedCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer criticalCount;

        private Integer highCount;

        private Integer mediumCount;

        private Integer lowCount;

        private Integer informationalCount;

        private Integer unspecifiedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SeveritySummary model) {
            criticalCount(model.criticalCount);
            highCount(model.highCount);
            mediumCount(model.mediumCount);
            lowCount(model.lowCount);
            informationalCount(model.informationalCount);
            unspecifiedCount(model.unspecifiedCount);
        }

        public final Integer getCriticalCount() {
            return criticalCount;
        }

        @Override
        public final Builder criticalCount(Integer criticalCount) {
            this.criticalCount = criticalCount;
            return this;
        }

        public final void setCriticalCount(Integer criticalCount) {
            this.criticalCount = criticalCount;
        }

        public final Integer getHighCount() {
            return highCount;
        }

        @Override
        public final Builder highCount(Integer highCount) {
            this.highCount = highCount;
            return this;
        }

        public final void setHighCount(Integer highCount) {
            this.highCount = highCount;
        }

        public final Integer getMediumCount() {
            return mediumCount;
        }

        @Override
        public final Builder mediumCount(Integer mediumCount) {
            this.mediumCount = mediumCount;
            return this;
        }

        public final void setMediumCount(Integer mediumCount) {
            this.mediumCount = mediumCount;
        }

        public final Integer getLowCount() {
            return lowCount;
        }

        @Override
        public final Builder lowCount(Integer lowCount) {
            this.lowCount = lowCount;
            return this;
        }

        public final void setLowCount(Integer lowCount) {
            this.lowCount = lowCount;
        }

        public final Integer getInformationalCount() {
            return informationalCount;
        }

        @Override
        public final Builder informationalCount(Integer informationalCount) {
            this.informationalCount = informationalCount;
            return this;
        }

        public final void setInformationalCount(Integer informationalCount) {
            this.informationalCount = informationalCount;
        }

        public final Integer getUnspecifiedCount() {
            return unspecifiedCount;
        }

        @Override
        public final Builder unspecifiedCount(Integer unspecifiedCount) {
            this.unspecifiedCount = unspecifiedCount;
            return this;
        }

        public final void setUnspecifiedCount(Integer unspecifiedCount) {
            this.unspecifiedCount = unspecifiedCount;
        }

        @Override
        public SeveritySummary build() {
            return new SeveritySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
