/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.ExecutionMode;
import software.amazon.awssdk.services.ssm.model.ProgressCounters;
import software.amazon.awssdk.services.ssm.model.ResolvedTargets;
import software.amazon.awssdk.services.ssm.model.StepExecution;
import software.amazon.awssdk.services.ssm.model.StepExecutionListCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecution> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::automationExecutionId)).setter(AutomationExecution.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::documentName)).setter(AutomationExecution.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::documentVersion)).setter(AutomationExecution.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecution.getter(AutomationExecution::executionStartTime)).setter(AutomationExecution.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecution.getter(AutomationExecution::executionEndTime)).setter(AutomationExecution.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::automationExecutionStatusAsString)).setter(AutomationExecution.setter(Builder::automationExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build()}).build();
    private static final SdkField<List<StepExecution>> STEP_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecution.getter(AutomationExecution::stepExecutions)).setter(AutomationExecution.setter(Builder::stepExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> STEP_EXECUTIONS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AutomationExecution.getter(AutomationExecution::stepExecutionsTruncated)).setter(AutomationExecution.setter(Builder::stepExecutionsTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutionsTruncated").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AutomationExecution.getter(AutomationExecution::parameters)).setter(AutomationExecution.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AutomationExecution.getter(AutomationExecution::outputs)).setter(AutomationExecution.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::failureMessage)).setter(AutomationExecution.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::modeAsString)).setter(AutomationExecution.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PARENT_AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::parentAutomationExecutionId)).setter(AutomationExecution.setter(Builder::parentAutomationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentAutomationExecutionId").build()}).build();
    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::executedBy)).setter(AutomationExecution.setter(Builder::executedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()}).build();
    private static final SdkField<String> CURRENT_STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::currentStepName)).setter(AutomationExecution.setter(Builder::currentStepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStepName").build()}).build();
    private static final SdkField<String> CURRENT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::currentAction)).setter(AutomationExecution.setter(Builder::currentAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAction").build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::targetParameterName)).setter(AutomationExecution.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecution.getter(AutomationExecution::targets)).setter(AutomationExecution.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecution.getter(AutomationExecution::targetMaps)).setter(AutomationExecution.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<ResolvedTargets> RESOLVED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutomationExecution.getter(AutomationExecution::resolvedTargets)).setter(AutomationExecution.setter(Builder::resolvedTargets)).constructor(ResolvedTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedTargets").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::maxConcurrency)).setter(AutomationExecution.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::maxErrors)).setter(AutomationExecution.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecution.getter(AutomationExecution::target)).setter(AutomationExecution.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecution.getter(AutomationExecution::targetLocations)).setter(AutomationExecution.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProgressCounters> PROGRESS_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutomationExecution.getter(AutomationExecution::progressCounters)).setter(AutomationExecution.setter(Builder::progressCounters)).constructor(ProgressCounters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressCounters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, STEP_EXECUTIONS_FIELD, STEP_EXECUTIONS_TRUNCATED_FIELD, PARAMETERS_FIELD, OUTPUTS_FIELD, FAILURE_MESSAGE_FIELD, MODE_FIELD, PARENT_AUTOMATION_EXECUTION_ID_FIELD, EXECUTED_BY_FIELD, CURRENT_STEP_NAME_FIELD, CURRENT_ACTION_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, RESOLVED_TARGETS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_FIELD, TARGET_LOCATIONS_FIELD, PROGRESS_COUNTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String automationExecutionStatus;
    private final List<StepExecution> stepExecutions;
    private final Boolean stepExecutionsTruncated;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> outputs;
    private final String failureMessage;
    private final String mode;
    private final String parentAutomationExecutionId;
    private final String executedBy;
    private final String currentStepName;
    private final String currentAction;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final ResolvedTargets resolvedTargets;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String target;
    private final List<TargetLocation> targetLocations;
    private final ProgressCounters progressCounters;

    private AutomationExecution(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.stepExecutions = builder.stepExecutions;
        this.stepExecutionsTruncated = builder.stepExecutionsTruncated;
        this.parameters = builder.parameters;
        this.outputs = builder.outputs;
        this.failureMessage = builder.failureMessage;
        this.mode = builder.mode;
        this.parentAutomationExecutionId = builder.parentAutomationExecutionId;
        this.executedBy = builder.executedBy;
        this.currentStepName = builder.currentStepName;
        this.currentAction = builder.currentAction;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.resolvedTargets = builder.resolvedTargets;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.target = builder.target;
        this.targetLocations = builder.targetLocations;
        this.progressCounters = builder.progressCounters;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Instant executionStartTime() {
        return this.executionStartTime;
    }

    public Instant executionEndTime() {
        return this.executionEndTime;
    }

    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public String automationExecutionStatusAsString() {
        return this.automationExecutionStatus;
    }

    public boolean hasStepExecutions() {
        return this.stepExecutions != null && !(this.stepExecutions instanceof SdkAutoConstructList);
    }

    public List<StepExecution> stepExecutions() {
        return this.stepExecutions;
    }

    public Boolean stepExecutionsTruncated() {
        return this.stepExecutionsTruncated;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public String parentAutomationExecutionId() {
        return this.parentAutomationExecutionId;
    }

    public String executedBy() {
        return this.executedBy;
    }

    public String currentStepName() {
        return this.currentStepName;
    }

    public String currentAction() {
        return this.currentAction;
    }

    public String targetParameterName() {
        return this.targetParameterName;
    }

    public boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public List<Target> targets() {
        return this.targets;
    }

    public boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public ResolvedTargets resolvedTargets() {
        return this.resolvedTargets;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String target() {
        return this.target;
    }

    public boolean hasTargetLocations() {
        return this.targetLocations != null && !(this.targetLocations instanceof SdkAutoConstructList);
    }

    public List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    public ProgressCounters progressCounters() {
        return this.progressCounters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutionsTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentAutomationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMaps());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressCounters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.automationExecutionStatusAsString(), other.automationExecutionStatusAsString()) && Objects.equals(this.stepExecutions(), other.stepExecutions()) && Objects.equals(this.stepExecutionsTruncated(), other.stepExecutionsTruncated()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.parentAutomationExecutionId(), other.parentAutomationExecutionId()) && Objects.equals(this.executedBy(), other.executedBy()) && Objects.equals(this.currentStepName(), other.currentStepName()) && Objects.equals(this.currentAction(), other.currentAction()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.resolvedTargets(), other.resolvedTargets()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.targetLocations(), other.targetLocations()) && Objects.equals(this.progressCounters(), other.progressCounters());
    }

    public String toString() {
        return ToString.builder((String)"AutomationExecution").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("AutomationExecutionStatus", (Object)this.automationExecutionStatusAsString()).add("StepExecutions", this.stepExecutions()).add("StepExecutionsTruncated", (Object)this.stepExecutionsTruncated()).add("Parameters", this.parameters()).add("Outputs", this.outputs()).add("FailureMessage", (Object)this.failureMessage()).add("Mode", (Object)this.modeAsString()).add("ParentAutomationExecutionId", (Object)this.parentAutomationExecutionId()).add("ExecutedBy", (Object)this.executedBy()).add("CurrentStepName", (Object)this.currentStepName()).add("CurrentAction", (Object)this.currentAction()).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.targets()).add("TargetMaps", this.targetMaps()).add("ResolvedTargets", (Object)this.resolvedTargets()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("Target", (Object)this.target()).add("TargetLocations", this.targetLocations()).add("ProgressCounters", (Object)this.progressCounters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "AutomationExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionStatusAsString()));
            }
            case "StepExecutions": {
                return Optional.ofNullable(clazz.cast(this.stepExecutions()));
            }
            case "StepExecutionsTruncated": {
                return Optional.ofNullable(clazz.cast(this.stepExecutionsTruncated()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "ParentAutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.parentAutomationExecutionId()));
            }
            case "ExecutedBy": {
                return Optional.ofNullable(clazz.cast(this.executedBy()));
            }
            case "CurrentStepName": {
                return Optional.ofNullable(clazz.cast(this.currentStepName()));
            }
            case "CurrentAction": {
                return Optional.ofNullable(clazz.cast(this.currentAction()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "ResolvedTargets": {
                return Optional.ofNullable(clazz.cast(this.resolvedTargets()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
            case "ProgressCounters": {
                return Optional.ofNullable(clazz.cast(this.progressCounters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecution, T> g) {
        return obj -> g.apply((AutomationExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String automationExecutionStatus;
        private List<StepExecution> stepExecutions = DefaultSdkAutoConstructList.getInstance();
        private Boolean stepExecutionsTruncated;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String failureMessage;
        private String mode;
        private String parentAutomationExecutionId;
        private String executedBy;
        private String currentStepName;
        private String currentAction;
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private ResolvedTargets resolvedTargets;
        private String maxConcurrency;
        private String maxErrors;
        private String target;
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();
        private ProgressCounters progressCounters;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecution model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.stepExecutions(model.stepExecutions);
            this.stepExecutionsTruncated(model.stepExecutionsTruncated);
            this.parameters(model.parameters);
            this.outputs(model.outputs);
            this.failureMessage(model.failureMessage);
            this.mode(model.mode);
            this.parentAutomationExecutionId(model.parentAutomationExecutionId);
            this.executedBy(model.executedBy);
            this.currentStepName(model.currentStepName);
            this.currentAction(model.currentAction);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.resolvedTargets(model.resolvedTargets);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.target(model.target);
            this.targetLocations(model.targetLocations);
            this.progressCounters(model.progressCounters);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getAutomationExecutionStatus() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus == null ? null : automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Collection<StepExecution.Builder> getStepExecutions() {
            return this.stepExecutions != null ? (Collection)this.stepExecutions.stream().map(StepExecution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stepExecutions(Collection<StepExecution> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copy(stepExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(StepExecution ... stepExecutions) {
            this.stepExecutions(Arrays.asList(stepExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepExecutions(Consumer<StepExecution.Builder> ... stepExecutions) {
            this.stepExecutions(Stream.of(stepExecutions).map(c -> (StepExecution)((StepExecution.Builder)StepExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStepExecutions(Collection<StepExecution.BuilderImpl> stepExecutions) {
            this.stepExecutions = StepExecutionListCopier.copyFromBuilder(stepExecutions);
        }

        public final Boolean getStepExecutionsTruncated() {
            return this.stepExecutionsTruncated;
        }

        @Override
        public final Builder stepExecutionsTruncated(Boolean stepExecutionsTruncated) {
            this.stepExecutionsTruncated = stepExecutionsTruncated;
            return this;
        }

        public final void setStepExecutionsTruncated(Boolean stepExecutionsTruncated) {
            this.stepExecutionsTruncated = stepExecutionsTruncated;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getParentAutomationExecutionId() {
            return this.parentAutomationExecutionId;
        }

        @Override
        public final Builder parentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
            return this;
        }

        public final void setParentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
        }

        public final String getExecutedBy() {
            return this.executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getCurrentStepName() {
            return this.currentStepName;
        }

        @Override
        public final Builder currentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
            return this;
        }

        public final void setCurrentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
        }

        public final String getCurrentAction() {
            return this.currentAction;
        }

        @Override
        public final Builder currentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public final void setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            return this.targetMaps;
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        public final ResolvedTargets.Builder getResolvedTargets() {
            return this.resolvedTargets != null ? this.resolvedTargets.toBuilder() : null;
        }

        @Override
        public final Builder resolvedTargets(ResolvedTargets resolvedTargets) {
            this.resolvedTargets = resolvedTargets;
            return this;
        }

        public final void setResolvedTargets(ResolvedTargets.BuilderImpl resolvedTargets) {
            this.resolvedTargets = resolvedTargets != null ? resolvedTargets.build() : null;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Collection<TargetLocation.Builder> getTargetLocations() {
            return this.targetLocations != null ? (Collection)this.targetLocations.stream().map(TargetLocation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        public final ProgressCounters.Builder getProgressCounters() {
            return this.progressCounters != null ? this.progressCounters.toBuilder() : null;
        }

        @Override
        public final Builder progressCounters(ProgressCounters progressCounters) {
            this.progressCounters = progressCounters;
            return this;
        }

        public final void setProgressCounters(ProgressCounters.BuilderImpl progressCounters) {
            this.progressCounters = progressCounters != null ? progressCounters.build() : null;
        }

        public AutomationExecution build() {
            return new AutomationExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecution> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder stepExecutions(Collection<StepExecution> var1);

        public Builder stepExecutions(StepExecution ... var1);

        public Builder stepExecutions(Consumer<StepExecution.Builder> ... var1);

        public Builder stepExecutionsTruncated(Boolean var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder failureMessage(String var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder parentAutomationExecutionId(String var1);

        public Builder executedBy(String var1);

        public Builder currentStepName(String var1);

        public Builder currentAction(String var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder resolvedTargets(ResolvedTargets var1);

        default public Builder resolvedTargets(Consumer<ResolvedTargets.Builder> resolvedTargets) {
            return this.resolvedTargets((ResolvedTargets)((ResolvedTargets.Builder)ResolvedTargets.builder().applyMutation(resolvedTargets)).build());
        }

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder target(String var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);

        public Builder progressCounters(ProgressCounters var1);

        default public Builder progressCounters(Consumer<ProgressCounters.Builder> progressCounters) {
            return this.progressCounters((ProgressCounters)((ProgressCounters.Builder)ProgressCounters.builder().applyMutation(progressCounters)).build());
        }
    }
}

