/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInventoryResponse extends SsmResponse implements
        ToCopyableBuilder<DeleteInventoryResponse.Builder, DeleteInventoryResponse> {
    private static final SdkField<String> DELETION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteInventoryResponse::deletionId)).setter(setter(Builder::deletionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionId").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteInventoryResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<InventoryDeletionSummary> DELETION_SUMMARY_FIELD = SdkField
            .<InventoryDeletionSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteInventoryResponse::deletionSummary)).setter(setter(Builder::deletionSummary))
            .constructor(InventoryDeletionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETION_ID_FIELD,
            TYPE_NAME_FIELD, DELETION_SUMMARY_FIELD));

    private final String deletionId;

    private final String typeName;

    private final InventoryDeletionSummary deletionSummary;

    private DeleteInventoryResponse(BuilderImpl builder) {
        super(builder);
        this.deletionId = builder.deletionId;
        this.typeName = builder.typeName;
        this.deletionSummary = builder.deletionSummary;
    }

    /**
     * <p>
     * Every <code>DeleteInventory</code> action is assigned a unique ID. This option returns a unique ID. You can use
     * this ID to query the status of a delete operation. This option is useful for ensuring that a delete operation has
     * completed before you begin other actions.
     * </p>
     * 
     * @return Every <code>DeleteInventory</code> action is assigned a unique ID. This option returns a unique ID. You
     *         can use this ID to query the status of a delete operation. This option is useful for ensuring that a
     *         delete operation has completed before you begin other actions.
     */
    public String deletionId() {
        return deletionId;
    }

    /**
     * <p>
     * The name of the inventory data type specified in the request.
     * </p>
     * 
     * @return The name of the inventory data type specified in the request.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * A summary of the delete operation. For more information about this summary, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary"
     * >Deleting custom inventory</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * 
     * @return A summary of the delete operation. For more information about this summary, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary"
     *         >Deleting custom inventory</a> in the <i>AWS Systems Manager User Guide</i>.
     */
    public InventoryDeletionSummary deletionSummary() {
        return deletionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInventoryResponse)) {
            return false;
        }
        DeleteInventoryResponse other = (DeleteInventoryResponse) obj;
        return Objects.equals(deletionId(), other.deletionId()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(deletionSummary(), other.deletionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteInventoryResponse").add("DeletionId", deletionId()).add("TypeName", typeName())
                .add("DeletionSummary", deletionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletionId":
            return Optional.ofNullable(clazz.cast(deletionId()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "DeletionSummary":
            return Optional.ofNullable(clazz.cast(deletionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInventoryResponse, T> g) {
        return obj -> g.apply((DeleteInventoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInventoryResponse> {
        /**
         * <p>
         * Every <code>DeleteInventory</code> action is assigned a unique ID. This option returns a unique ID. You can
         * use this ID to query the status of a delete operation. This option is useful for ensuring that a delete
         * operation has completed before you begin other actions.
         * </p>
         * 
         * @param deletionId
         *        Every <code>DeleteInventory</code> action is assigned a unique ID. This option returns a unique ID.
         *        You can use this ID to query the status of a delete operation. This option is useful for ensuring that
         *        a delete operation has completed before you begin other actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionId(String deletionId);

        /**
         * <p>
         * The name of the inventory data type specified in the request.
         * </p>
         * 
         * @param typeName
         *        The name of the inventory data type specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * A summary of the delete operation. For more information about this summary, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary"
         * >Deleting custom inventory</a> in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param deletionSummary
         *        A summary of the delete operation. For more information about this summary, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary"
         *        >Deleting custom inventory</a> in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionSummary(InventoryDeletionSummary deletionSummary);

        /**
         * <p>
         * A summary of the delete operation. For more information about this summary, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-custom.html#sysman-inventory-delete-summary"
         * >Deleting custom inventory</a> in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link InventoryDeletionSummary.Builder} avoiding the
         * need to create one manually via {@link InventoryDeletionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link InventoryDeletionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #deletionSummary(InventoryDeletionSummary)}.
         * 
         * @param deletionSummary
         *        a consumer that will call methods on {@link InventoryDeletionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletionSummary(InventoryDeletionSummary)
         */
        default Builder deletionSummary(Consumer<InventoryDeletionSummary.Builder> deletionSummary) {
            return deletionSummary(InventoryDeletionSummary.builder().applyMutation(deletionSummary).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String deletionId;

        private String typeName;

        private InventoryDeletionSummary deletionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInventoryResponse model) {
            super(model);
            deletionId(model.deletionId);
            typeName(model.typeName);
            deletionSummary(model.deletionSummary);
        }

        public final String getDeletionId() {
            return deletionId;
        }

        @Override
        public final Builder deletionId(String deletionId) {
            this.deletionId = deletionId;
            return this;
        }

        public final void setDeletionId(String deletionId) {
            this.deletionId = deletionId;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final InventoryDeletionSummary.Builder getDeletionSummary() {
            return deletionSummary != null ? deletionSummary.toBuilder() : null;
        }

        @Override
        public final Builder deletionSummary(InventoryDeletionSummary deletionSummary) {
            this.deletionSummary = deletionSummary;
            return this;
        }

        public final void setDeletionSummary(InventoryDeletionSummary.BuilderImpl deletionSummary) {
            this.deletionSummary = deletionSummary != null ? deletionSummary.build() : null;
        }

        @Override
        public DeleteInventoryResponse build() {
            return new DeleteInventoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
