/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsEntityItemEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsEntityItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsEntityItem> {
    private static final SdkField<String> CAPTURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptureTime").getter(OpsEntityItem.getter(OpsEntityItem::captureTime)).setter(OpsEntityItem.setter(Builder::captureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()}).build();
    private static final SdkField<List<Map<String, String>>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Content").getter(OpsEntityItem.getter(OpsEntityItem::content)).setter(OpsEntityItem.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_TIME_FIELD, CONTENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String captureTime;
    private final List<Map<String, String>> content;

    private OpsEntityItem(BuilderImpl builder) {
        this.captureTime = builder.captureTime;
        this.content = builder.content;
    }

    public String captureTime() {
        return this.captureTime;
    }

    public boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public List<Map<String, String>> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsEntityItem)) {
            return false;
        }
        OpsEntityItem other = (OpsEntityItem)obj;
        return Objects.equals(this.captureTime(), other.captureTime()) && Objects.equals(this.content(), other.content());
    }

    public String toString() {
        return ToString.builder((String)"OpsEntityItem").add("CaptureTime", (Object)this.captureTime()).add("Content", this.content()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptureTime": {
                return Optional.ofNullable(clazz.cast(this.captureTime()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsEntityItem, T> g) {
        return obj -> g.apply((OpsEntityItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String captureTime;
        private List<Map<String, String>> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsEntityItem model) {
            this.captureTime(model.captureTime);
            this.content(model.content);
        }

        public final String getCaptureTime() {
            return this.captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final Collection<? extends Map<String, String>> getContent() {
            return this.content;
        }

        @Override
        public final Builder content(Collection<? extends Map<String, String>> content) {
            this.content = OpsEntityItemEntryListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Map<String, String> ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        public final void setContent(Collection<? extends Map<String, String>> content) {
            this.content = OpsEntityItemEntryListCopier.copy(content);
        }

        public OpsEntityItem build() {
            return new OpsEntityItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsEntityItem> {
        public Builder captureTime(String var1);

        public Builder content(Collection<? extends Map<String, String>> var1);

        public Builder content(Map<String, String> ... var1);
    }
}

