/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a command request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Command implements SdkPojo, Serializable, ToCopyableBuilder<Command.Builder, Command> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommandId").getter(getter(Command::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(Command::documentName)).setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(Command::documentVersion)).setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Comment")
            .getter(getter(Command::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<Instant> EXPIRES_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiresAfter").getter(getter(Command::expiresAfter)).setter(setter(Builder::expiresAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAfter").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(Command::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(Command::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(Command::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> REQUESTED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestedDateTime").getter(getter(Command::requestedDateTime))
            .setter(setter(Builder::requestedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Command::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetails").getter(getter(Command::statusDetails)).setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<String> OUTPUT_S3_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3Region").getter(getter(Command::outputS3Region)).setter(setter(Builder::outputS3Region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Region").build()).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3BucketName").getter(getter(Command::outputS3BucketName))
            .setter(setter(Builder::outputS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build())
            .build();

    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3KeyPrefix").getter(getter(Command::outputS3KeyPrefix))
            .setter(setter(Builder::outputS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(Command::maxConcurrency)).setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(Command::maxErrors)).setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<Integer> TARGET_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetCount").getter(getter(Command::targetCount)).setter(setter(Builder::targetCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCount").build()).build();

    private static final SdkField<Integer> COMPLETED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CompletedCount").getter(getter(Command::completedCount)).setter(setter(Builder::completedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedCount").build()).build();

    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorCount").getter(getter(Command::errorCount)).setter(setter(Builder::errorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCount").build()).build();

    private static final SdkField<Integer> DELIVERY_TIMED_OUT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeliveryTimedOutCount").getter(getter(Command::deliveryTimedOutCount))
            .setter(setter(Builder::deliveryTimedOutCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTimedOutCount").build())
            .build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(Command::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<NotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField
            .<NotificationConfig> builder(MarshallingType.SDK_POJO).memberName("NotificationConfig")
            .getter(getter(Command::notificationConfig)).setter(setter(Builder::notificationConfig))
            .constructor(NotificationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build())
            .build();

    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField
            .<CloudWatchOutputConfig> builder(MarshallingType.SDK_POJO).memberName("CloudWatchOutputConfig")
            .getter(getter(Command::cloudWatchOutputConfig)).setter(setter(Builder::cloudWatchOutputConfig))
            .constructor(CloudWatchOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutSeconds").getter(getter(Command::timeoutSeconds)).setter(setter(Builder::timeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, COMMENT_FIELD, EXPIRES_AFTER_FIELD, PARAMETERS_FIELD,
            INSTANCE_IDS_FIELD, TARGETS_FIELD, REQUESTED_DATE_TIME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD,
            OUTPUT_S3_REGION_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, MAX_CONCURRENCY_FIELD,
            MAX_ERRORS_FIELD, TARGET_COUNT_FIELD, COMPLETED_COUNT_FIELD, ERROR_COUNT_FIELD, DELIVERY_TIMED_OUT_COUNT_FIELD,
            SERVICE_ROLE_FIELD, NOTIFICATION_CONFIG_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD, TIMEOUT_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commandId;

    private final String documentName;

    private final String documentVersion;

    private final String comment;

    private final Instant expiresAfter;

    private final Map<String, List<String>> parameters;

    private final List<String> instanceIds;

    private final List<Target> targets;

    private final Instant requestedDateTime;

    private final String status;

    private final String statusDetails;

    private final String outputS3Region;

    private final String outputS3BucketName;

    private final String outputS3KeyPrefix;

    private final String maxConcurrency;

    private final String maxErrors;

    private final Integer targetCount;

    private final Integer completedCount;

    private final Integer errorCount;

    private final Integer deliveryTimedOutCount;

    private final String serviceRole;

    private final NotificationConfig notificationConfig;

    private final CloudWatchOutputConfig cloudWatchOutputConfig;

    private final Integer timeoutSeconds;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.comment = builder.comment;
        this.expiresAfter = builder.expiresAfter;
        this.parameters = builder.parameters;
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.requestedDateTime = builder.requestedDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetCount = builder.targetCount;
        this.completedCount = builder.completedCount;
        this.errorCount = builder.errorCount;
        this.deliveryTimedOutCount = builder.deliveryTimedOutCount;
        this.serviceRole = builder.serviceRole;
        this.notificationConfig = builder.notificationConfig;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    /**
     * <p>
     * A unique identifier for this command.
     * </p>
     * 
     * @return A unique identifier for this command.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The name of the document requested for execution.
     * </p>
     * 
     * @return The name of the document requested for execution.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The SSM document version.
     * </p>
     * 
     * @return The SSM document version.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * User-specified information about the command, such as a brief description of what the command should do.
     * </p>
     * 
     * @return User-specified information about the command, such as a brief description of what the command should do.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * If this time is reached and the command has not already started running, it will not run. Calculated based on the
     * ExpiresAfter user input provided as part of the SendCommand API.
     * </p>
     * 
     * @return If this time is reached and the command has not already started running, it will not run. Calculated
     *         based on the ExpiresAfter user input provided as part of the SendCommand API.
     */
    public Instant expiresAfter() {
        return expiresAfter;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameter values to be inserted in the document when running the command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameter values to be inserted in the document when running the command.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * Returns true if the InstanceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance IDs against which this command was requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instance IDs against which this command was requested.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is
     * required if you don't provide one or more instance IDs in the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of search criteria that targets instances using a Key,Value combination that you specify.
     *         Targets is required if you don't provide one or more instance IDs in the call.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The date and time the command was requested.
     * </p>
     * 
     * @return The date and time the command was requested.
     */
    public Instant requestedDateTime() {
        return requestedDateTime;
    }

    /**
     * <p>
     * The status of the command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the command.
     * @see CommandStatus
     */
    public CommandStatus status() {
        return CommandStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the command.
     * @see CommandStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed status of the command execution. StatusDetails includes more information than Status because it
     * includes states resulting from error and concurrency control parameters. StatusDetails can show different results
     * than Status. For more information about these statuses, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
     * statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The command has not been sent to any instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * In Progress: The command has been sent to at least one instance but has not reached a final state on all
     * instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Success: The command successfully ran on all invocations. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out. This
     * is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed Out.
     * This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Incomplete: The command was attempted on all instances and one or more invocations does not have a value of
     * Success but not enough invocations failed for the status to be Failed. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Canceled: The command was terminated before it was completed. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Rate Exceeded: The number of instances targeted by the command exceeded the account limit for pending
     * invocations. The system has canceled the command before running it on any instance. This is a terminal state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A detailed status of the command execution. StatusDetails includes more information than Status because
     *         it includes states resulting from error and concurrency control parameters. StatusDetails can show
     *         different results than Status. For more information about these statuses, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding
     *         command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the
     *         following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The command has not been sent to any instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Progress: The command has been sent to at least one instance but has not reached a final state on all
     *         instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Success: The command successfully ran on all invocations. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed
     *         Out. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed
     *         Out. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal
     *         state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Incomplete: The command was attempted on all instances and one or more invocations does not have a value
     *         of Success but not enough invocations failed for the status to be Failed. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Canceled: The command was terminated before it was completed. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rate Exceeded: The number of instances targeted by the command exceeded the account limit for pending
     *         invocations. The system has canceled the command before running it on any instance. This is a terminal
     *         state.
     *         </p>
     *         </li>
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     * automatically determines the Region of the S3 bucket.
     * </p>
     * 
     * @return (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     *         automatically determines the Region of the S3 bucket.
     */
    public String outputS3Region() {
        return outputS3Region;
    }

    /**
     * <p>
     * The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the
     * command.
     * </p>
     * 
     * @return The S3 bucket where the responses to the command executions should be stored. This was requested when
     *         issuing the command.
     */
    public String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * The S3 directory path inside the bucket where the responses to the command executions should be stored. This was
     * requested when issuing the command.
     * </p>
     * 
     * @return The S3 directory path inside the bucket where the responses to the command executions should be stored.
     *         This was requested when issuing the command.
     */
    public String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * The maximum number of instances that are allowed to run the command at the same time. You can specify a number of
     * instances, such as 10, or a percentage of instances, such as 10%. The default value is 50. For more information
     * about how to use MaxConcurrency, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using
     * Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * 
     * @return The maximum number of instances that are allowed to run the command at the same time. You can specify a
     *         number of instances, such as 10, or a percentage of instances, such as 10%. The default value is 50. For
     *         more information about how to use MaxConcurrency, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands
     *         using Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed before the system stops sending the command to additional targets. You can
     * specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is 0. For more
     * information about how to use MaxErrors, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using
     * Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * 
     * @return The maximum number of errors allowed before the system stops sending the command to additional targets.
     *         You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value
     *         is 0. For more information about how to use MaxErrors, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands
     *         using Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The number of targets for the command.
     * </p>
     * 
     * @return The number of targets for the command.
     */
    public Integer targetCount() {
        return targetCount;
    }

    /**
     * <p>
     * The number of targets for which the command invocation reached a terminal state. Terminal states include the
     * following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled, Terminated, or Undeliverable.
     * </p>
     * 
     * @return The number of targets for which the command invocation reached a terminal state. Terminal states include
     *         the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled, Terminated, or
     *         Undeliverable.
     */
    public Integer completedCount() {
        return completedCount;
    }

    /**
     * <p>
     * The number of targets for which the status is Failed or Execution Timed Out.
     * </p>
     * 
     * @return The number of targets for which the status is Failed or Execution Timed Out.
     */
    public Integer errorCount() {
        return errorCount;
    }

    /**
     * <p>
     * The number of targets for which the status is Delivery Timed Out.
     * </p>
     * 
     * @return The number of targets for which the status is Delivery Timed Out.
     */
    public Integer deliveryTimedOutCount() {
        return deliveryTimedOutCount;
    }

    /**
     * <p>
     * The IAM service role that Run Command uses to act on your behalf when sending notifications about command status
     * changes.
     * </p>
     * 
     * @return The IAM service role that Run Command uses to act on your behalf when sending notifications about command
     *         status changes.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * Configurations for sending notifications about command status changes.
     * </p>
     * 
     * @return Configurations for sending notifications about command status changes.
     */
    public NotificationConfig notificationConfig() {
        return notificationConfig;
    }

    /**
     * <p>
     * CloudWatch Logs information where you want Systems Manager to send the command output.
     * </p>
     * 
     * @return CloudWatch Logs information where you want Systems Manager to send the command output.
     */
    public CloudWatchOutputConfig cloudWatchOutputConfig() {
        return cloudWatchOutputConfig;
    }

    /**
     * <p>
     * The <code>TimeoutSeconds</code> value specified for a command.
     * </p>
     * 
     * @return The <code>TimeoutSeconds</code> value specified for a command.
     */
    public Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAfter());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(requestedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(completedCount());
        hashCode = 31 * hashCode + Objects.hashCode(errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryTimedOutCount());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion()) && Objects.equals(comment(), other.comment())
                && Objects.equals(expiresAfter(), other.expiresAfter()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(instanceIds(), other.instanceIds()) && Objects.equals(targets(), other.targets())
                && Objects.equals(requestedDateTime(), other.requestedDateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(outputS3Region(), other.outputS3Region())
                && Objects.equals(outputS3BucketName(), other.outputS3BucketName())
                && Objects.equals(outputS3KeyPrefix(), other.outputS3KeyPrefix())
                && Objects.equals(maxConcurrency(), other.maxConcurrency()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(targetCount(), other.targetCount()) && Objects.equals(completedCount(), other.completedCount())
                && Objects.equals(errorCount(), other.errorCount())
                && Objects.equals(deliveryTimedOutCount(), other.deliveryTimedOutCount())
                && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(notificationConfig(), other.notificationConfig())
                && Objects.equals(cloudWatchOutputConfig(), other.cloudWatchOutputConfig())
                && Objects.equals(timeoutSeconds(), other.timeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Command").add("CommandId", commandId()).add("DocumentName", documentName())
                .add("DocumentVersion", documentVersion()).add("Comment", comment()).add("ExpiresAfter", expiresAfter())
                .add("Parameters", parameters()).add("InstanceIds", instanceIds()).add("Targets", targets())
                .add("RequestedDateTime", requestedDateTime()).add("Status", statusAsString())
                .add("StatusDetails", statusDetails()).add("OutputS3Region", outputS3Region())
                .add("OutputS3BucketName", outputS3BucketName()).add("OutputS3KeyPrefix", outputS3KeyPrefix())
                .add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors()).add("TargetCount", targetCount())
                .add("CompletedCount", completedCount()).add("ErrorCount", errorCount())
                .add("DeliveryTimedOutCount", deliveryTimedOutCount()).add("ServiceRole", serviceRole())
                .add("NotificationConfig", notificationConfig()).add("CloudWatchOutputConfig", cloudWatchOutputConfig())
                .add("TimeoutSeconds", timeoutSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "ExpiresAfter":
            return Optional.ofNullable(clazz.cast(expiresAfter()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "RequestedDateTime":
            return Optional.ofNullable(clazz.cast(requestedDateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "OutputS3Region":
            return Optional.ofNullable(clazz.cast(outputS3Region()));
        case "OutputS3BucketName":
            return Optional.ofNullable(clazz.cast(outputS3BucketName()));
        case "OutputS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(outputS3KeyPrefix()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "TargetCount":
            return Optional.ofNullable(clazz.cast(targetCount()));
        case "CompletedCount":
            return Optional.ofNullable(clazz.cast(completedCount()));
        case "ErrorCount":
            return Optional.ofNullable(clazz.cast(errorCount()));
        case "DeliveryTimedOutCount":
            return Optional.ofNullable(clazz.cast(deliveryTimedOutCount()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "NotificationConfig":
            return Optional.ofNullable(clazz.cast(notificationConfig()));
        case "CloudWatchOutputConfig":
            return Optional.ofNullable(clazz.cast(cloudWatchOutputConfig()));
        case "TimeoutSeconds":
            return Optional.ofNullable(clazz.cast(timeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Command, T> g) {
        return obj -> g.apply((Command) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Command> {
        /**
         * <p>
         * A unique identifier for this command.
         * </p>
         * 
         * @param commandId
         *        A unique identifier for this command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The name of the document requested for execution.
         * </p>
         * 
         * @param documentName
         *        The name of the document requested for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The SSM document version.
         * </p>
         * 
         * @param documentVersion
         *        The SSM document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * User-specified information about the command, such as a brief description of what the command should do.
         * </p>
         * 
         * @param comment
         *        User-specified information about the command, such as a brief description of what the command should
         *        do.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * If this time is reached and the command has not already started running, it will not run. Calculated based on
         * the ExpiresAfter user input provided as part of the SendCommand API.
         * </p>
         * 
         * @param expiresAfter
         *        If this time is reached and the command has not already started running, it will not run. Calculated
         *        based on the ExpiresAfter user input provided as part of the SendCommand API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAfter(Instant expiresAfter);

        /**
         * <p>
         * The parameter values to be inserted in the document when running the command.
         * </p>
         * 
         * @param parameters
         *        The parameter values to be inserted in the document when running the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The instance IDs against which this command was requested.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs against which this command was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The instance IDs against which this command was requested.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs against which this command was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is
         * required if you don't provide one or more instance IDs in the call.
         * </p>
         * 
         * @param targets
         *        An array of search criteria that targets instances using a Key,Value combination that you specify.
         *        Targets is required if you don't provide one or more instance IDs in the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is
         * required if you don't provide one or more instance IDs in the call.
         * </p>
         * 
         * @param targets
         *        An array of search criteria that targets instances using a Key,Value combination that you specify.
         *        Targets is required if you don't provide one or more instance IDs in the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * An array of search criteria that targets instances using a Key,Value combination that you specify. Targets is
         * required if you don't provide one or more instance IDs in the call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The date and time the command was requested.
         * </p>
         * 
         * @param requestedDateTime
         *        The date and time the command was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDateTime(Instant requestedDateTime);

        /**
         * <p>
         * The status of the command.
         * </p>
         * 
         * @param status
         *        The status of the command.
         * @see CommandStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the command.
         * </p>
         * 
         * @param status
         *        The status of the command.
         * @see CommandStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandStatus
         */
        Builder status(CommandStatus status);

        /**
         * <p>
         * A detailed status of the command execution. StatusDetails includes more information than Status because it
         * includes states resulting from error and concurrency control parameters. StatusDetails can show different
         * results than Status. For more information about these statuses, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding
         * command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be one of the following
         * values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The command has not been sent to any instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: The command has been sent to at least one instance but has not reached a final state on all
         * instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * Success: The command successfully ran on all invocations. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery Timed Out.
         * This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution Timed
         * Out. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a terminal
         * state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Incomplete: The command was attempted on all instances and one or more invocations does not have a value of
         * Success but not enough invocations failed for the status to be Failed. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Canceled: The command was terminated before it was completed. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Rate Exceeded: The number of instances targeted by the command exceeded the account limit for pending
         * invocations. The system has canceled the command before running it on any instance. This is a terminal state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusDetails
         *        A detailed status of the command execution. StatusDetails includes more information than Status
         *        because it includes states resulting from error and concurrency control parameters. StatusDetails can
         *        show different results than Status. For more information about these statuses, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html"
         *        >Understanding command statuses</a> in the <i>AWS Systems Manager User Guide</i>. StatusDetails can be
         *        one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The command has not been sent to any instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: The command has been sent to at least one instance but has not reached a final state on
         *        all instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Success: The command successfully ran on all invocations. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delivery Timed Out: The value of MaxErrors or more command invocations shows a status of Delivery
         *        Timed Out. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Execution Timed Out: The value of MaxErrors or more command invocations shows a status of Execution
         *        Timed Out. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The value of MaxErrors or more command invocations shows a status of Failed. This is a
         *        terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Incomplete: The command was attempted on all instances and one or more invocations does not have a
         *        value of Success but not enough invocations failed for the status to be Failed. This is a terminal
         *        state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Canceled: The command was terminated before it was completed. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rate Exceeded: The number of instances targeted by the command exceeded the account limit for pending
         *        invocations. The system has canceled the command before running it on any instance. This is a terminal
         *        state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         * automatically determines the Region of the S3 bucket.
         * </p>
         * 
         * @param outputS3Region
         *        (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         *        automatically determines the Region of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Region(String outputS3Region);

        /**
         * <p>
         * The S3 bucket where the responses to the command executions should be stored. This was requested when issuing
         * the command.
         * </p>
         * 
         * @param outputS3BucketName
         *        The S3 bucket where the responses to the command executions should be stored. This was requested when
         *        issuing the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * The S3 directory path inside the bucket where the responses to the command executions should be stored. This
         * was requested when issuing the command.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The S3 directory path inside the bucket where the responses to the command executions should be
         *        stored. This was requested when issuing the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * The maximum number of instances that are allowed to run the command at the same time. You can specify a
         * number of instances, such as 10, or a percentage of instances, such as 10%. The default value is 50. For more
         * information about how to use MaxConcurrency, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using
         * Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of instances that are allowed to run the command at the same time. You can specify
         *        a number of instances, such as 10, or a percentage of instances, such as 10%. The default value is 50.
         *        For more information about how to use MaxConcurrency, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands
         *        using Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed before the system stops sending the command to additional targets. You
         * can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The default value is 0.
         * For more information about how to use MaxErrors, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands using
         * Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
         * </p>
         * 
         * @param maxErrors
         *        The maximum number of errors allowed before the system stops sending the command to additional
         *        targets. You can specify a number of errors, such as 10, or a percentage or errors, such as 10%. The
         *        default value is 0. For more information about how to use MaxErrors, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html">Running commands
         *        using Systems Manager Run Command</a> in the <i>AWS Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The number of targets for the command.
         * </p>
         * 
         * @param targetCount
         *        The number of targets for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCount(Integer targetCount);

        /**
         * <p>
         * The number of targets for which the command invocation reached a terminal state. Terminal states include the
         * following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled, Terminated, or Undeliverable.
         * </p>
         * 
         * @param completedCount
         *        The number of targets for which the command invocation reached a terminal state. Terminal states
         *        include the following: Success, Failed, Execution Timed Out, Delivery Timed Out, Canceled, Terminated,
         *        or Undeliverable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedCount(Integer completedCount);

        /**
         * <p>
         * The number of targets for which the status is Failed or Execution Timed Out.
         * </p>
         * 
         * @param errorCount
         *        The number of targets for which the status is Failed or Execution Timed Out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCount(Integer errorCount);

        /**
         * <p>
         * The number of targets for which the status is Delivery Timed Out.
         * </p>
         * 
         * @param deliveryTimedOutCount
         *        The number of targets for which the status is Delivery Timed Out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryTimedOutCount(Integer deliveryTimedOutCount);

        /**
         * <p>
         * The IAM service role that Run Command uses to act on your behalf when sending notifications about command
         * status changes.
         * </p>
         * 
         * @param serviceRole
         *        The IAM service role that Run Command uses to act on your behalf when sending notifications about
         *        command status changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * Configurations for sending notifications about command status changes.
         * </p>
         * 
         * @param notificationConfig
         *        Configurations for sending notifications about command status changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfig(NotificationConfig notificationConfig);

        /**
         * <p>
         * Configurations for sending notifications about command status changes.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationConfig.Builder} avoiding the need to
         * create one manually via {@link NotificationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #notificationConfig(NotificationConfig)}.
         * 
         * @param notificationConfig
         *        a consumer that will call methods on {@link NotificationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfig(NotificationConfig)
         */
        default Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return notificationConfig(NotificationConfig.builder().applyMutation(notificationConfig).build());
        }

        /**
         * <p>
         * CloudWatch Logs information where you want Systems Manager to send the command output.
         * </p>
         * 
         * @param cloudWatchOutputConfig
         *        CloudWatch Logs information where you want Systems Manager to send the command output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig);

        /**
         * <p>
         * CloudWatch Logs information where you want Systems Manager to send the command output.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchOutputConfig.Builder} avoiding the
         * need to create one manually via {@link CloudWatchOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchOutputConfig(CloudWatchOutputConfig)}.
         * 
         * @param cloudWatchOutputConfig
         *        a consumer that will call methods on {@link CloudWatchOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchOutputConfig(CloudWatchOutputConfig)
         */
        default Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return cloudWatchOutputConfig(CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig).build());
        }

        /**
         * <p>
         * The <code>TimeoutSeconds</code> value specified for a command.
         * </p>
         * 
         * @param timeoutSeconds
         *        The <code>TimeoutSeconds</code> value specified for a command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String commandId;

        private String documentName;

        private String documentVersion;

        private String comment;

        private Instant expiresAfter;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private Instant requestedDateTime;

        private String status;

        private String statusDetails;

        private String outputS3Region;

        private String outputS3BucketName;

        private String outputS3KeyPrefix;

        private String maxConcurrency;

        private String maxErrors;

        private Integer targetCount;

        private Integer completedCount;

        private Integer errorCount;

        private Integer deliveryTimedOutCount;

        private String serviceRole;

        private NotificationConfig notificationConfig;

        private CloudWatchOutputConfig cloudWatchOutputConfig;

        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            commandId(model.commandId);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            comment(model.comment);
            expiresAfter(model.expiresAfter);
            parameters(model.parameters);
            instanceIds(model.instanceIds);
            targets(model.targets);
            requestedDateTime(model.requestedDateTime);
            status(model.status);
            statusDetails(model.statusDetails);
            outputS3Region(model.outputS3Region);
            outputS3BucketName(model.outputS3BucketName);
            outputS3KeyPrefix(model.outputS3KeyPrefix);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            targetCount(model.targetCount);
            completedCount(model.completedCount);
            errorCount(model.errorCount);
            deliveryTimedOutCount(model.deliveryTimedOutCount);
            serviceRole(model.serviceRole);
            notificationConfig(model.notificationConfig);
            cloudWatchOutputConfig(model.cloudWatchOutputConfig);
            timeoutSeconds(model.timeoutSeconds);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getExpiresAfter() {
            return expiresAfter;
        }

        @Override
        public final Builder expiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public final void setExpiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        public final Collection<Target.Builder> getTargets() {
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Instant getRequestedDateTime() {
            return requestedDateTime;
        }

        @Override
        public final Builder requestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            return this;
        }

        public final void setRequestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getOutputS3Region() {
            return outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final Integer getTargetCount() {
            return targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        public final Integer getCompletedCount() {
            return completedCount;
        }

        @Override
        public final Builder completedCount(Integer completedCount) {
            this.completedCount = completedCount;
            return this;
        }

        public final void setCompletedCount(Integer completedCount) {
            this.completedCount = completedCount;
        }

        public final Integer getErrorCount() {
            return errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        public final Integer getDeliveryTimedOutCount() {
            return deliveryTimedOutCount;
        }

        @Override
        public final Builder deliveryTimedOutCount(Integer deliveryTimedOutCount) {
            this.deliveryTimedOutCount = deliveryTimedOutCount;
            return this;
        }

        public final void setDeliveryTimedOutCount(Integer deliveryTimedOutCount) {
            this.deliveryTimedOutCount = deliveryTimedOutCount;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return notificationConfig != null ? notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return cloudWatchOutputConfig != null ? cloudWatchOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public Command build() {
            return new Command(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
