/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDocumentVersionsResponse extends SsmResponse implements
        ToCopyableBuilder<ListDocumentVersionsResponse.Builder, ListDocumentVersionsResponse> {
    private static final SdkField<List<DocumentVersionInfo>> DOCUMENT_VERSIONS_FIELD = SdkField
            .<List<DocumentVersionInfo>> builder(MarshallingType.LIST)
            .memberName("DocumentVersions")
            .getter(getter(ListDocumentVersionsResponse::documentVersions))
            .setter(setter(Builder::documentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentVersionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentVersionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDocumentVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DocumentVersionInfo> documentVersions;

    private final String nextToken;

    private ListDocumentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.documentVersions = builder.documentVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DocumentVersions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDocumentVersions() {
        return documentVersions != null && !(documentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The document versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDocumentVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The document versions.
     */
    public List<DocumentVersionInfo> documentVersions() {
        return documentVersions;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentVersionsResponse)) {
            return false;
        }
        ListDocumentVersionsResponse other = (ListDocumentVersionsResponse) obj;
        return Objects.equals(documentVersions(), other.documentVersions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDocumentVersionsResponse").add("DocumentVersions", documentVersions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentVersions":
            return Optional.ofNullable(clazz.cast(documentVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentVersionsResponse, T> g) {
        return obj -> g.apply((ListDocumentVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDocumentVersionsResponse> {
        /**
         * <p>
         * The document versions.
         * </p>
         * 
         * @param documentVersions
         *        The document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersions(Collection<DocumentVersionInfo> documentVersions);

        /**
         * <p>
         * The document versions.
         * </p>
         * 
         * @param documentVersions
         *        The document versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersions(DocumentVersionInfo... documentVersions);

        /**
         * <p>
         * The document versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentVersionInfo>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentVersionInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentVersionInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #documentVersions(List<DocumentVersionInfo>)}.
         * 
         * @param documentVersions
         *        a consumer that will call methods on {@link List<DocumentVersionInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentVersions(List<DocumentVersionInfo>)
         */
        Builder documentVersions(Consumer<DocumentVersionInfo.Builder>... documentVersions);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<DocumentVersionInfo> documentVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentVersionsResponse model) {
            super(model);
            documentVersions(model.documentVersions);
            nextToken(model.nextToken);
        }

        public final Collection<DocumentVersionInfo.Builder> getDocumentVersions() {
            return documentVersions != null ? documentVersions.stream().map(DocumentVersionInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentVersions(Collection<DocumentVersionInfo> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copy(documentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(DocumentVersionInfo... documentVersions) {
            documentVersions(Arrays.asList(documentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentVersions(Consumer<DocumentVersionInfo.Builder>... documentVersions) {
            documentVersions(Stream.of(documentVersions).map(c -> DocumentVersionInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentVersions(Collection<DocumentVersionInfo.BuilderImpl> documentVersions) {
            this.documentVersions = DocumentVersionListCopier.copyFromBuilder(documentVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentVersionsResponse build() {
            return new ListDocumentVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
