/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteParametersResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DeleteParametersResponse> {
    private static final SdkField<List<String>> DELETED_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeletedParameters").getter(DeleteParametersResponse.getter(DeleteParametersResponse::deletedParameters)).setter(DeleteParametersResponse.setter(Builder::deletedParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INVALID_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvalidParameters").getter(DeleteParametersResponse.getter(DeleteParametersResponse::invalidParameters)).setter(DeleteParametersResponse.setter(Builder::invalidParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_PARAMETERS_FIELD, INVALID_PARAMETERS_FIELD));
    private final List<String> deletedParameters;
    private final List<String> invalidParameters;

    private DeleteParametersResponse(BuilderImpl builder) {
        super(builder);
        this.deletedParameters = builder.deletedParameters;
        this.invalidParameters = builder.invalidParameters;
    }

    public boolean hasDeletedParameters() {
        return this.deletedParameters != null && !(this.deletedParameters instanceof SdkAutoConstructList);
    }

    public List<String> deletedParameters() {
        return this.deletedParameters;
    }

    public boolean hasInvalidParameters() {
        return this.invalidParameters != null && !(this.invalidParameters instanceof SdkAutoConstructList);
    }

    public List<String> invalidParameters() {
        return this.invalidParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeletedParameters() ? this.deletedParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidParameters() ? this.invalidParameters() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersResponse)) {
            return false;
        }
        DeleteParametersResponse other = (DeleteParametersResponse)((Object)obj);
        return this.hasDeletedParameters() == other.hasDeletedParameters() && Objects.equals(this.deletedParameters(), other.deletedParameters()) && this.hasInvalidParameters() == other.hasInvalidParameters() && Objects.equals(this.invalidParameters(), other.invalidParameters());
    }

    public String toString() {
        return ToString.builder((String)"DeleteParametersResponse").add("DeletedParameters", this.hasDeletedParameters() ? this.deletedParameters() : null).add("InvalidParameters", this.hasInvalidParameters() ? this.invalidParameters() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeletedParameters": {
                return Optional.ofNullable(clazz.cast(this.deletedParameters()));
            }
            case "InvalidParameters": {
                return Optional.ofNullable(clazz.cast(this.invalidParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteParametersResponse, T> g) {
        return obj -> g.apply((DeleteParametersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<String> deletedParameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> invalidParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersResponse model) {
            super(model);
            this.deletedParameters(model.deletedParameters);
            this.invalidParameters(model.invalidParameters);
        }

        public final Collection<String> getDeletedParameters() {
            if (this.deletedParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deletedParameters;
        }

        @Override
        public final Builder deletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedParameters(String ... deletedParameters) {
            this.deletedParameters(Arrays.asList(deletedParameters));
            return this;
        }

        public final void setDeletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
        }

        public final Collection<String> getInvalidParameters() {
            if (this.invalidParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String ... invalidParameters) {
            this.invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @Override
        public DeleteParametersResponse build() {
            return new DeleteParametersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteParametersResponse> {
        public Builder deletedParameters(Collection<String> var1);

        public Builder deletedParameters(String ... var1);

        public Builder invalidParameters(Collection<String> var1);

        public Builder invalidParameters(String ... var1);
    }
}

