/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents metadata about a patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Patch implements SdkPojo, Serializable, ToCopyableBuilder<Patch.Builder, Patch> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Patch::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReleaseDate").getter(getter(Patch::releaseDate)).setter(setter(Builder::releaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseDate").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(Patch::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Patch::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTENT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentUrl").getter(getter(Patch::contentUrl)).setter(setter(Builder::contentUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentUrl").build()).build();

    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Vendor")
            .getter(getter(Patch::vendor)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()).build();

    private static final SdkField<String> PRODUCT_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductFamily").getter(getter(Patch::productFamily)).setter(setter(Builder::productFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductFamily").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(Patch::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Classification").getter(getter(Patch::classification)).setter(setter(Builder::classification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()).build();

    private static final SdkField<String> MSRC_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MsrcSeverity").getter(getter(Patch::msrcSeverity)).setter(setter(Builder::msrcSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MsrcSeverity").build()).build();

    private static final SdkField<String> KB_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KbNumber").getter(getter(Patch::kbNumber)).setter(setter(Builder::kbNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KbNumber").build()).build();

    private static final SdkField<String> MSRC_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MsrcNumber").getter(getter(Patch::msrcNumber)).setter(setter(Builder::msrcNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MsrcNumber").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(Patch::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RELEASE_DATE_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, CONTENT_URL_FIELD, VENDOR_FIELD, PRODUCT_FAMILY_FIELD, PRODUCT_FIELD,
            CLASSIFICATION_FIELD, MSRC_SEVERITY_FIELD, KB_NUMBER_FIELD, MSRC_NUMBER_FIELD, LANGUAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant releaseDate;

    private final String title;

    private final String description;

    private final String contentUrl;

    private final String vendor;

    private final String productFamily;

    private final String product;

    private final String classification;

    private final String msrcSeverity;

    private final String kbNumber;

    private final String msrcNumber;

    private final String language;

    private Patch(BuilderImpl builder) {
        this.id = builder.id;
        this.releaseDate = builder.releaseDate;
        this.title = builder.title;
        this.description = builder.description;
        this.contentUrl = builder.contentUrl;
        this.vendor = builder.vendor;
        this.productFamily = builder.productFamily;
        this.product = builder.product;
        this.classification = builder.classification;
        this.msrcSeverity = builder.msrcSeverity;
        this.kbNumber = builder.kbNumber;
        this.msrcNumber = builder.msrcNumber;
        this.language = builder.language;
    }

    /**
     * <p>
     * The ID of the patch (this is different than the Microsoft Knowledge Base ID).
     * </p>
     * 
     * @return The ID of the patch (this is different than the Microsoft Knowledge Base ID).
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The date the patch was released.
     * </p>
     * 
     * @return The date the patch was released.
     */
    public Instant releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * The title of the patch.
     * </p>
     * 
     * @return The title of the patch.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The description of the patch.
     * </p>
     * 
     * @return The description of the patch.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The URL where more information can be obtained about the patch.
     * </p>
     * 
     * @return The URL where more information can be obtained about the patch.
     */
    public String contentUrl() {
        return contentUrl;
    }

    /**
     * <p>
     * The name of the vendor providing the patch.
     * </p>
     * 
     * @return The name of the vendor providing the patch.
     */
    public String vendor() {
        return vendor;
    }

    /**
     * <p>
     * The product family the patch is applicable for (for example, Windows).
     * </p>
     * 
     * @return The product family the patch is applicable for (for example, Windows).
     */
    public String productFamily() {
        return productFamily;
    }

    /**
     * <p>
     * The specific product the patch is applicable for (for example, WindowsServer2016).
     * </p>
     * 
     * @return The specific product the patch is applicable for (for example, WindowsServer2016).
     */
    public String product() {
        return product;
    }

    /**
     * <p>
     * The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
     * </p>
     * 
     * @return The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
     */
    public String classification() {
        return classification;
    }

    /**
     * <p>
     * The severity of the patch (for example Critical, Important, Moderate).
     * </p>
     * 
     * @return The severity of the patch (for example Critical, Important, Moderate).
     */
    public String msrcSeverity() {
        return msrcSeverity;
    }

    /**
     * <p>
     * The Microsoft Knowledge Base ID of the patch.
     * </p>
     * 
     * @return The Microsoft Knowledge Base ID of the patch.
     */
    public String kbNumber() {
        return kbNumber;
    }

    /**
     * <p>
     * The ID of the MSRC bulletin the patch is related to.
     * </p>
     * 
     * @return The ID of the MSRC bulletin the patch is related to.
     */
    public String msrcNumber() {
        return msrcNumber;
    }

    /**
     * <p>
     * The language of the patch if it's language-specific.
     * </p>
     * 
     * @return The language of the patch if it's language-specific.
     */
    public String language() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(contentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        hashCode = 31 * hashCode + Objects.hashCode(productFamily());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(classification());
        hashCode = 31 * hashCode + Objects.hashCode(msrcSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(kbNumber());
        hashCode = 31 * hashCode + Objects.hashCode(msrcNumber());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Patch)) {
            return false;
        }
        Patch other = (Patch) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(releaseDate(), other.releaseDate())
                && Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(contentUrl(), other.contentUrl()) && Objects.equals(vendor(), other.vendor())
                && Objects.equals(productFamily(), other.productFamily()) && Objects.equals(product(), other.product())
                && Objects.equals(classification(), other.classification())
                && Objects.equals(msrcSeverity(), other.msrcSeverity()) && Objects.equals(kbNumber(), other.kbNumber())
                && Objects.equals(msrcNumber(), other.msrcNumber()) && Objects.equals(language(), other.language());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Patch").add("Id", id()).add("ReleaseDate", releaseDate()).add("Title", title())
                .add("Description", description()).add("ContentUrl", contentUrl()).add("Vendor", vendor())
                .add("ProductFamily", productFamily()).add("Product", product()).add("Classification", classification())
                .add("MsrcSeverity", msrcSeverity()).add("KbNumber", kbNumber()).add("MsrcNumber", msrcNumber())
                .add("Language", language()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ReleaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ContentUrl":
            return Optional.ofNullable(clazz.cast(contentUrl()));
        case "Vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        case "ProductFamily":
            return Optional.ofNullable(clazz.cast(productFamily()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Classification":
            return Optional.ofNullable(clazz.cast(classification()));
        case "MsrcSeverity":
            return Optional.ofNullable(clazz.cast(msrcSeverity()));
        case "KbNumber":
            return Optional.ofNullable(clazz.cast(kbNumber()));
        case "MsrcNumber":
            return Optional.ofNullable(clazz.cast(msrcNumber()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Patch, T> g) {
        return obj -> g.apply((Patch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Patch> {
        /**
         * <p>
         * The ID of the patch (this is different than the Microsoft Knowledge Base ID).
         * </p>
         * 
         * @param id
         *        The ID of the patch (this is different than the Microsoft Knowledge Base ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date the patch was released.
         * </p>
         * 
         * @param releaseDate
         *        The date the patch was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(Instant releaseDate);

        /**
         * <p>
         * The title of the patch.
         * </p>
         * 
         * @param title
         *        The title of the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the patch.
         * </p>
         * 
         * @param description
         *        The description of the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URL where more information can be obtained about the patch.
         * </p>
         * 
         * @param contentUrl
         *        The URL where more information can be obtained about the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentUrl(String contentUrl);

        /**
         * <p>
         * The name of the vendor providing the patch.
         * </p>
         * 
         * @param vendor
         *        The name of the vendor providing the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * The product family the patch is applicable for (for example, Windows).
         * </p>
         * 
         * @param productFamily
         *        The product family the patch is applicable for (for example, Windows).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productFamily(String productFamily);

        /**
         * <p>
         * The specific product the patch is applicable for (for example, WindowsServer2016).
         * </p>
         * 
         * @param product
         *        The specific product the patch is applicable for (for example, WindowsServer2016).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
         * </p>
         * 
         * @param classification
         *        The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classification(String classification);

        /**
         * <p>
         * The severity of the patch (for example Critical, Important, Moderate).
         * </p>
         * 
         * @param msrcSeverity
         *        The severity of the patch (for example Critical, Important, Moderate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msrcSeverity(String msrcSeverity);

        /**
         * <p>
         * The Microsoft Knowledge Base ID of the patch.
         * </p>
         * 
         * @param kbNumber
         *        The Microsoft Knowledge Base ID of the patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kbNumber(String kbNumber);

        /**
         * <p>
         * The ID of the MSRC bulletin the patch is related to.
         * </p>
         * 
         * @param msrcNumber
         *        The ID of the MSRC bulletin the patch is related to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msrcNumber(String msrcNumber);

        /**
         * <p>
         * The language of the patch if it's language-specific.
         * </p>
         * 
         * @param language
         *        The language of the patch if it's language-specific.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant releaseDate;

        private String title;

        private String description;

        private String contentUrl;

        private String vendor;

        private String productFamily;

        private String product;

        private String classification;

        private String msrcSeverity;

        private String kbNumber;

        private String msrcNumber;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(Patch model) {
            id(model.id);
            releaseDate(model.releaseDate);
            title(model.title);
            description(model.description);
            contentUrl(model.contentUrl);
            vendor(model.vendor);
            productFamily(model.productFamily);
            product(model.product);
            classification(model.classification);
            msrcSeverity(model.msrcSeverity);
            kbNumber(model.kbNumber);
            msrcNumber(model.msrcNumber);
            language(model.language);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getReleaseDate() {
            return releaseDate;
        }

        @Override
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getContentUrl() {
            return contentUrl;
        }

        @Override
        public final Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public final void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        public final String getVendor() {
            return vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public final String getProductFamily() {
            return productFamily;
        }

        @Override
        public final Builder productFamily(String productFamily) {
            this.productFamily = productFamily;
            return this;
        }

        public final void setProductFamily(String productFamily) {
            this.productFamily = productFamily;
        }

        public final String getProduct() {
            return product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        public final String getClassification() {
            return classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getMsrcSeverity() {
            return msrcSeverity;
        }

        @Override
        public final Builder msrcSeverity(String msrcSeverity) {
            this.msrcSeverity = msrcSeverity;
            return this;
        }

        public final void setMsrcSeverity(String msrcSeverity) {
            this.msrcSeverity = msrcSeverity;
        }

        public final String getKbNumber() {
            return kbNumber;
        }

        @Override
        public final Builder kbNumber(String kbNumber) {
            this.kbNumber = kbNumber;
            return this;
        }

        public final void setKbNumber(String kbNumber) {
            this.kbNumber = kbNumber;
        }

        public final String getMsrcNumber() {
            return msrcNumber;
        }

        @Override
        public final Builder msrcNumber(String msrcNumber) {
            this.msrcNumber = msrcNumber;
            return this;
        }

        public final void setMsrcNumber(String msrcNumber) {
            this.msrcNumber = msrcNumber;
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Patch build() {
            return new Patch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
